/*
 * Decompiled with CFR 0.152.
 */
package mercury.normal;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import mercury.SignUtils;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.FromAddresses;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.FromNormalAddresses;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToAddress;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.req.ToNormalAddress;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class Secp256k1Test {
    @Test
    void testFromSecp256k1() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1()))));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.pay_by_from), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(new Gson().toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testToSecp256k1() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress0())), Source.unconstrained));
        builder.addItem((ToAddress)new ToNormalAddress(AddressWithKeyHolder.testAddress4()), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(new Gson().toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

