/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.AdjustAccountPayload;
import org.nervos.mercury.model.req.CollectAssetPayload;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.GetBalancePayload;
import org.nervos.mercury.model.req.GetBlockInfoPayload;
import org.nervos.mercury.model.req.KeyAddress;
import org.nervos.mercury.model.req.NormalAddress;
import org.nervos.mercury.model.req.QueryAddress;
import org.nervos.mercury.model.req.QueryTransactionsPayload;
import org.nervos.mercury.model.req.SmartTo;
import org.nervos.mercury.model.req.SmartTransferPayload;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.req.TransferPayload;
import org.nervos.mercury.model.resp.AssetInfo;
import org.nervos.mercury.model.resp.BalanceResponse;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.QueryTransactionsResponse;
import org.nervos.mercury.model.resp.RecordResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import org.nervos.mercury.model.resp.TransactionInfoWithStatusResponse;

public class DefaultMercuryApi
implements MercuryApi {
    private RpcService rpcService;
    private Gson g = new GsonBuilder().registerTypeAdapter(QueryAddress.class, (Object)new KeyAddress("")).registerTypeAdapter(QueryAddress.class, (Object)new NormalAddress("")).registerTypeAdapter(RecordResponse.class, (Object)new RecordResponse()).create();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    public DefaultMercuryApi(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        GetBalanceResponse.RpcGetBalanceResponse resp = (GetBalanceResponse.RpcGetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(payload), GetBalanceResponse.RpcGetBalanceResponse.class, this.g);
        GetBalanceResponse result = new GetBalanceResponse();
        result.balances = resp.balances.stream().map(x -> {
            BalanceResponse balance = new BalanceResponse();
            balance.address = x.keyAddress;
            balance.free = x.unconstrained;
            balance.claimable = x.fleeting;
            balance.freezed = x.locked;
            balance.assetInfo = Objects.isNull(x.udtHash) || x.udtHash == "" ? AssetInfo.newCkbAsset() : AssetInfo.newUdtAsset(x.udtHash);
            return balance;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        List transferItems = payload.items.stream().filter(x -> Objects.equals(x.to.getClass(), ToKeyAddress.class)).collect(Collectors.toList());
        if (transferItems.size() > 0 && payload.items.stream().anyMatch(item -> item.to.isPayByFrom() == false) && (payload.udtHash == null || payload.udtHash == "")) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_asset_account_creation_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildSmartTransferTransaction(SmartTransferPayload payload) throws IOException {
        return this.buildTransferTransaction(this.toTransferPayload(payload));
    }

    @Override
    public TransactionInfoWithStatusResponse getTransactionInfo(String txHash) throws IOException {
        return (TransactionInfoWithStatusResponse)this.rpcService.post("get_generic_transaction", Arrays.asList(txHash), TransactionInfoWithStatusResponse.class, this.g);
    }

    @Override
    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return (BlockInfoResponse)this.rpcService.post("get_generic_block", Arrays.asList(payload), BlockInfoResponse.class, this.g);
    }

    @Override
    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return (List)this.rpcService.post("register_addresses", Arrays.asList(normalAddresses), new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public TransactionCompletionResponse buildAssetCollectionTransaction(CollectAssetPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_asset_collection_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public QueryTransactionsResponse queryTransactions(QueryTransactionsPayload payload) throws IOException {
        return (QueryTransactionsResponse)this.rpcService.post("query_generic_transactions", Arrays.asList(payload), QueryTransactionsResponse.class);
    }

    @Override
    public Integer getAccountNumber(String address) throws IOException {
        return (Integer)this.rpcService.post("get_account_number", Arrays.asList(address), Integer.class);
    }

    private TransferPayload toTransferPayload(SmartTransferPayload payload) throws IOException {
        List<GetBalanceResponse> fromBalances = this.getBalance(payload.from, payload.assetInfo);
        List<GetBalanceResponse> toBalance = this.getBalance(payload.to.stream().map(x -> x.address).collect(Collectors.toList()), payload.assetInfo);
        this.feePay(payload, fromBalances, toBalance);
        Source source = this.getSource(payload.assetInfo, fromBalances, payload.to);
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from(new FromKeyAddresses(payload.from.stream().collect(Collectors.toSet()), source));
        for (SmartTo to : payload.to) {
            if (Objects.equals((Object)payload.assetInfo.assetType, (Object)AssetInfo.AssetType.UDT) && this.getAccountNumber(to.address).compareTo(0) > 0) {
                builder.addItem(new ToKeyAddress(to.address, Action.pay_by_to), to.amount);
                continue;
            }
            builder.addItem(new ToKeyAddress(to.address, Action.pay_by_from), to.amount);
        }
        if (Objects.equals((Object)payload.assetInfo.assetType, (Object)AssetInfo.AssetType.UDT)) {
            builder.udtHash(payload.assetInfo.udtHash);
        }
        System.out.println(new Gson().toJson((Object)builder.build()));
        return builder.build();
    }

    private Source getSource(AssetInfo assetInfo, List<GetBalanceResponse> fromBalances, List<SmartTo> to) {
        BigInteger totalAmount;
        BigInteger fromBalance = this.getBalance(fromBalances, assetInfo.assetType, "claimable");
        if (fromBalance.compareTo(totalAmount = to.stream().map(x -> x.amount).reduce(BigInteger.ZERO, (x, y) -> x.add((BigInteger)y))) >= 0) {
            return Source.fleeting;
        }
        return Source.unconstrained;
    }

    private void feePay(SmartTransferPayload payload, List<GetBalanceResponse> fromBalances, List<GetBalanceResponse> toBalances) {
        BigInteger from = this.getBalance(fromBalances, AssetInfo.AssetType.CKB, "free");
        BigInteger to = this.getBalance(toBalances, AssetInfo.AssetType.CKB, "free");
        BigInteger feeThreshold = AmountUtils.ckbToShannon((double)1.0E-4);
        if (from.compareTo(feeThreshold) < 0 && to.compareTo(feeThreshold) < 0) {
            throw new RuntimeException("CKB Insufficient balance to pay the fee");
        }
        if (from.compareTo(feeThreshold) < 0 && to.compareTo(feeThreshold) >= 0) {
            payload.from.addAll(toBalances.stream().flatMap(x -> x.balances.stream().map(y -> y.address)).collect(Collectors.toSet()));
            return;
        }
        if (from.compareTo(feeThreshold) > 0) {
            return;
        }
        throw new RuntimeException("CKB Insufficient balance to pay the fee");
    }

    private BigInteger getBalance(List<GetBalanceResponse> fromBalances, AssetInfo.AssetType assetType, String balanceType) {
        return fromBalances.stream().map(x -> {
            BalanceResponse balanceResponse = x.balances.stream().filter(y -> Objects.equals((Object)y.assetInfo.assetType, (Object)assetType)).findAny().get();
            if (Objects.equals(balanceType, "free")) {
                return balanceResponse.free;
            }
            if (Objects.equals(balanceType, "claimable")) {
                return balanceResponse.claimable;
            }
            if (Objects.equals(balanceType, "freezed")) {
                return balanceResponse.freezed;
            }
            return BigInteger.ZERO;
        }).reduce(BigInteger.ZERO, (x, y) -> x.add((BigInteger)y));
    }

    private List<GetBalanceResponse> getBalance(List<String> addresses, AssetInfo udtAsset) throws IOException {
        ArrayList<GetBalanceResponse> result = new ArrayList<GetBalanceResponse>(addresses.size());
        for (String address : addresses) {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address(address);
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            if (Objects.nonNull(udtAsset)) {
                builder.addAssetInfo(udtAsset);
            }
            GetBalanceResponse balance = this.getBalance(builder.build());
            result.add(balance);
        }
        return result;
    }
}

