/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.nervos.ckb.service.RpcService;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.common.AssetType;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.RecordStatus;
import org.nervos.mercury.model.common.ViewType;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.payload.AdjustAccountPayload;
import org.nervos.mercury.model.req.payload.DepositPayload;
import org.nervos.mercury.model.req.payload.GetBalancePayload;
import org.nervos.mercury.model.req.payload.GetBlockInfoPayload;
import org.nervos.mercury.model.req.payload.GetSpentTransactionPayload;
import org.nervos.mercury.model.req.payload.QueryTransactionsPayload;
import org.nervos.mercury.model.req.payload.SmartTransferPayload;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.req.payload.WithdrawPayload;
import org.nervos.mercury.model.resp.AddressOrLockHash;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.GetTransactionInfoResponse;
import org.nervos.mercury.model.resp.RecordResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import org.nervos.mercury.model.resp.TransactionInfo;
import org.nervos.mercury.model.resp.TransactionView;
import org.nervos.mercury.model.resp.info.DBInfo;
import org.nervos.mercury.model.resp.info.MercuryInfo;

public class DefaultMercuryApi
implements MercuryApi {
    private RpcService rpcService;
    private Gson g = new GsonBuilder().registerTypeAdapter(AddressOrLockHash.class, (Object)new AddressOrLockHash()).registerTypeAdapter(RecordStatus.class, (Object)new RecordStatus()).registerTypeAdapter(RecordResponse.class, (Object)new RecordResponse()).create();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    public DefaultMercuryApi(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        GetBalanceResponse resp = (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(payload), GetBalanceResponse.class, this.g);
        return resp;
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        if (Objects.equals((Object)payload.assetInfo.assetType, (Object)AssetType.CKB) && Objects.equals((Object)payload.from.source, (Object)Source.Claimable)) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildSmartTransferTransaction(SmartTransferPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_smart_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_adjust_account_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public GetTransactionInfoResponse getTransactionInfo(String txHash) throws IOException {
        return (GetTransactionInfoResponse)this.rpcService.post("get_transaction_info", Arrays.asList(txHash), GetTransactionInfoResponse.class, this.g);
    }

    @Override
    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return (BlockInfoResponse)this.rpcService.post("get_block_info", Arrays.asList(payload), BlockInfoResponse.class, this.g);
    }

    @Override
    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return (List)this.rpcService.post("register_addresses", Arrays.asList(normalAddresses), new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public PaginationResponse<TransactionView> queryTransactionsWithTransactionView(QueryTransactionsPayload payload) throws IOException {
        payload.viewType = ViewType.Native;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TransactionView>>(){}.getType(), this.g);
    }

    @Override
    public PaginationResponse<TransactionInfo> queryTransactionsWithTransactionInfo(QueryTransactionsPayload payload) throws IOException {
        payload.viewType = ViewType.DoubleEntry;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TransactionInfo>>(){}.getType(), this.g);
    }

    @Override
    public DBInfo getDbInfo() throws IOException {
        return (DBInfo)this.rpcService.post("get_db_info", Arrays.asList(new Object[0]), DBInfo.class);
    }

    @Override
    public MercuryInfo getMercuryInfo() throws IOException {
        return (MercuryInfo)this.rpcService.post("get_mercury_info", Arrays.asList(new Object[0]), MercuryInfo.class);
    }

    @Override
    public TransactionCompletionResponse buildDepositTransaction(DepositPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_deposit_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildWithdrawTransaction(WithdrawPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_withdraw_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionView getSpentTransactionWithTransactionView(GetSpentTransactionPayload payload) throws IOException {
        return (TransactionView)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), TransactionView.class);
    }

    @Override
    public TransactionInfo getSpentTransactionWithTransactionInfo(GetSpentTransactionPayload payload) throws IOException {
        return (TransactionInfo)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), TransactionInfo.class);
    }
}

