/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.resp;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.resp.AssetStatus;

public class RecordResponse
implements JsonSerializer<RecordResponse>,
JsonDeserializer<RecordResponse> {
    public Integer id;
    public String address;
    public BigInteger amount;
    public AssetInfo assetInfo;
    public AssetStatus status;
    public BigInteger blockNumber;

    public RecordResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        RecordResponse record = new RecordResponse();
        JsonObject jsonObject = json.getAsJsonObject();
        if (this.fieldExist(jsonObject, "id")) {
            record.id = jsonObject.get("id").getAsInt();
        }
        if (this.fieldExist(jsonObject, "key_address")) {
            record.address = jsonObject.get("key_address").getAsString();
        }
        if (this.fieldExist(jsonObject, "amount")) {
            JsonObject amount = jsonObject.get("amount").getAsJsonObject();
            if (this.fieldExist(amount, "value")) {
                record.amount = amount.get("value").getAsBigInteger();
            }
            record.assetInfo = this.fieldExist(amount, "udt_hash") ? AssetInfo.newUdtAsset(amount.get("udt_hash").getAsString()) : AssetInfo.newCkbAsset();
            if (this.fieldExist(amount, "status")) {
                JsonObject status = amount.get("status").getAsJsonObject();
                if (this.fieldExist(status, "claimable")) {
                    record.status = AssetStatus.CLAIMABLE;
                    record.blockNumber = status.get("claimable").getAsBigInteger();
                } else if (this.fieldExist(status, "fixed")) {
                    record.status = AssetStatus.FIXED;
                    record.blockNumber = status.get("fixed").getAsBigInteger();
                }
            }
        }
        return record;
    }

    private boolean fieldExist(JsonObject jsonObject, String fieldName) {
        return jsonObject.has(fieldName) && !jsonObject.get(fieldName).isJsonNull();
    }

    public JsonElement serialize(RecordResponse src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src, src.getClass());
    }
}

