/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nervos.ckb.service.RpcService;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.TipResponse;
import org.nervos.indexer.model.resp.TransactionResponse;
import org.nervos.mercury.GsonFactory;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.common.AssetType;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.ViewType;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.payload.AdjustAccountPayload;
import org.nervos.mercury.model.req.payload.DaoClaimPayload;
import org.nervos.mercury.model.req.payload.DaoDepositPayload;
import org.nervos.mercury.model.req.payload.DaoWithdrawPayload;
import org.nervos.mercury.model.req.payload.GetBalancePayload;
import org.nervos.mercury.model.req.payload.GetBlockInfoPayload;
import org.nervos.mercury.model.req.payload.GetSpentTransactionPayload;
import org.nervos.mercury.model.req.payload.QueryTransactionsPayload;
import org.nervos.mercury.model.req.payload.SimpleTransferPayload;
import org.nervos.mercury.model.req.payload.SudtIssuePayload;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.GetTransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import org.nervos.mercury.model.resp.TransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionWithRichStatus;
import org.nervos.mercury.model.resp.TxView;
import org.nervos.mercury.model.resp.indexer.MercuryCellsResponse;
import org.nervos.mercury.model.resp.indexer.MercuryTransactionResponse;
import org.nervos.mercury.model.resp.info.DBInfo;
import org.nervos.mercury.model.resp.info.MercuryInfo;
import org.nervos.mercury.model.resp.info.MercurySyncState;

public class DefaultMercuryApi
implements MercuryApi {
    private RpcService rpcService;
    private Gson g = GsonFactory.newGson();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    public DefaultMercuryApi(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        GetBalanceResponse resp = (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(payload), GetBalanceResponse.class, this.g);
        return resp;
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        if (Objects.equals((Object)payload.assetInfo.assetType, (Object)AssetType.CKB) && Objects.equals((Object)payload.from.source, (Object)Source.Claimable)) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public TransactionCompletionResponse buildSimpleTransferTransaction(SimpleTransferPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_simple_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public TransactionCompletionResponse buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_adjust_account_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public GetTransactionInfoResponse getTransactionInfo(String txHash) throws IOException {
        return (GetTransactionInfoResponse)this.rpcService.post("get_transaction_info", Arrays.asList(txHash), GetTransactionInfoResponse.class, this.g);
    }

    @Override
    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return (BlockInfoResponse)this.rpcService.post("get_block_info", Arrays.asList(payload), BlockInfoResponse.class, this.g);
    }

    @Override
    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return (List)this.rpcService.post("register_addresses", Arrays.asList(normalAddresses), new TypeToken<List<String>>(){}.getType(), this.g);
    }

    @Override
    public PaginationResponse<TxView<TransactionWithRichStatus>> queryTransactionsWithTransactionView(QueryTransactionsPayload payload) throws IOException {
        payload.viewType = ViewType.Native;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TxView<TransactionWithRichStatus>>>(){}.getType(), this.g);
    }

    @Override
    public PaginationResponse<TxView<TransactionInfoResponse>> queryTransactionsWithTransactionInfo(QueryTransactionsPayload payload) throws IOException {
        payload.viewType = ViewType.DoubleEntry;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TxView<TransactionInfoResponse>>>(){}.getType(), this.g);
    }

    @Override
    public DBInfo getDbInfo() throws IOException {
        return (DBInfo)this.rpcService.post("get_db_info", Arrays.asList(new Object[0]), DBInfo.class);
    }

    @Override
    public MercuryInfo getMercuryInfo() throws IOException {
        return (MercuryInfo)this.rpcService.post("get_mercury_info", Arrays.asList(new Object[0]), MercuryInfo.class);
    }

    @Override
    public MercurySyncState getSyncState() throws IOException {
        return (MercurySyncState)this.rpcService.post("get_sync_state", Arrays.asList(new Object[0]), MercurySyncState.class);
    }

    @Override
    public TransactionCompletionResponse buildDaoDepositTransaction(DaoDepositPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_dao_deposit_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public TransactionCompletionResponse buildDaoWithdrawTransaction(DaoWithdrawPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_dao_withdraw_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public TransactionCompletionResponse buildDaoClaimTransaction(DaoClaimPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_dao_claim_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }

    @Override
    public TxView<TransactionWithRichStatus> getSpentTransactionWithTransactionView(GetSpentTransactionPayload payload) throws IOException {
        payload.structureType = ViewType.Native;
        return (TxView)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), new TypeToken<TxView<TransactionWithRichStatus>>(){}.getType(), this.g);
    }

    @Override
    public TxView<TransactionInfoResponse> getSpentTransactionWithTransactionInfo(GetSpentTransactionPayload payload) throws IOException {
        payload.structureType = ViewType.DoubleEntry;
        return (TxView)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), new TypeToken<TxView<TransactionInfoResponse>>(){}.getType(), this.g);
    }

    @Override
    public CellsResponse getCells(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        List mercuryCursor = afterCursor == null || afterCursor == "" ? null : Arrays.stream(afterCursor.split(",")).map(x -> Integer.valueOf(x)).collect(Collectors.toList());
        MercuryCellsResponse response = (MercuryCellsResponse)this.rpcService.post("get_cells", Arrays.asList(searchKey, order, limit, mercuryCursor), MercuryCellsResponse.class);
        return response.toCellsResponse();
    }

    @Override
    public TransactionResponse getTransactions(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        List mercuryCursor = afterCursor == null || afterCursor == "" ? null : Arrays.stream(afterCursor.split(",")).map(x -> Integer.valueOf(x)).collect(Collectors.toList());
        MercuryTransactionResponse response = (MercuryTransactionResponse)this.rpcService.post("get_transactions", Arrays.asList(searchKey, order, limit, mercuryCursor), MercuryTransactionResponse.class);
        return response.toTransactionResponse();
    }

    @Override
    public TipResponse getTip() throws IOException {
        return (TipResponse)this.rpcService.post("get_tip", Arrays.asList(new Object[0]), TipResponse.class);
    }

    @Override
    public CellCapacityResponse getCellsCapacity(SearchKey searchKey) throws IOException {
        return (CellCapacityResponse)this.rpcService.post("get_cells_capacity", Arrays.asList(searchKey), CellCapacityResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildSudtIssueTransaction(SudtIssuePayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_sudt_issue_transaction", Arrays.asList(payload), TransactionCompletionResponse.class, this.g);
    }
}

