/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.QueryTransactionsPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.Range;
import org.nervos.mercury.model.req.item.ItemFactory;

public class QueryTransactionsTest {
    Gson g = new Gson();

    @Test
    void testQueryGenericTransactionsWithCkb() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(new Gson().toJson((Object)builder.build()));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithUdt() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithAll() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            System.out.println(new Gson().toJson((Object)builder.build()));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithChequeAddress() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)this.getChequeAddress()));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithAcpAddress() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)this.getAcpAddress()));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithFromBlock() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.range(new Range(new BigInteger("2224987"), null));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithToBlock() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.range(new Range(null, new BigInteger("2224987")));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithFromBlockAndToBlock() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.range(new Range(new BigInteger("2224993"), new BigInteger("2225023")));
            System.out.println(new Gson().toJson((Object)builder.build()));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithLimit() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.limit(new BigInteger("2"));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithOrder() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.order("asc");
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithOffset() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
            builder.limit(new BigInteger("1"));
            PaginationResponse resp = MercuryApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getAcpAddress() {
        return AddressTools.generateAcpAddress((String)AddressWithKeyHolder.queryTransactionAddress());
    }

    private String getChequeAddress() {
        return AddressTools.generateChequeAddress((String)AddressWithKeyHolder.testAddress0(), (String)AddressWithKeyHolder.queryTransactionAddress());
    }
}

