/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import constant.UdtHolder;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.utils.Numeric;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.item.ItemFactory;
import org.nervos.mercury.model.resp.GetBalanceResponse;

public class BalanceTest {
    @Test
    void getCkbBalance() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        builder.addAssetInfo(AssetInfo.newCkbAsset());
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertEquals((int)2, (int)balance.balances.size());
    }

    @Test
    void getSudtBalance() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        builder.addAssetInfo(AssetInfo.newUdtAsset((byte[])UdtHolder.UDT_HASH));
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertEquals((int)2, (int)balance.balances.size());
        Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
    }

    @Test
    void getAllBalance() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
        Assertions.assertNotEquals((int)0, (int)balance.balances.size());
    }

    @Test
    void getBalanceByAddress() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.testAddress4()));
        builder.addAssetInfo(AssetInfo.newCkbAsset());
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertNotEquals((int)0, (int)balance.balances.size());
    }

    @Test
    void getBalanceByIdentity() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        builder.addAssetInfo(AssetInfo.newUdtAsset((byte[])UdtHolder.UDT_HASH));
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertNotEquals((int)0, (int)balance.balances.size());
    }

    @Test
    void getBalanceByRecordByScriptByChequeCellSender() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newOutPointItem((byte[])Numeric.hexStringToByteArray((String)"0x52b1cf0ad857d53e1a3552944c1acf268f6a6aea8e8fc85fe8febcb8127d56f0"), (int)0));
        builder.addAssetInfo(AssetInfo.newCkbAsset());
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertNotEquals((int)0, (int)balance.balances.size());
    }

    @Test
    void getBalanceByRecordByScriptChequeCellReceiver() throws IOException {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newOutPointItem((byte[])Numeric.hexStringToByteArray((String)"0x52b1cf0ad857d53e1a3552944c1acf268f6a6aea8e8fc85fe8febcb8127d56f0"), (int)0));
        builder.addAssetInfo(AssetInfo.newUdtAsset((byte[])UdtHolder.UDT_HASH));
        GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
        Assertions.assertNotEquals((int)0, (int)balance.balances.size());
    }
}

