/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.nervos.ckb.service.GsonFactory;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.StructureType;
import org.nervos.mercury.model.req.payload.AccountInfoPayload;
import org.nervos.mercury.model.req.payload.AdjustAccountPayload;
import org.nervos.mercury.model.req.payload.DaoClaimPayload;
import org.nervos.mercury.model.req.payload.DaoDepositPayload;
import org.nervos.mercury.model.req.payload.DaoWithdrawPayload;
import org.nervos.mercury.model.req.payload.GetBalancePayload;
import org.nervos.mercury.model.req.payload.GetBlockInfoPayload;
import org.nervos.mercury.model.req.payload.GetSpentTransactionPayload;
import org.nervos.mercury.model.req.payload.QueryTransactionsPayload;
import org.nervos.mercury.model.req.payload.SimpleTransferPayload;
import org.nervos.mercury.model.req.payload.SudtIssuePayload;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.resp.AccountInfo;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.GetTransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionWithRichStatus;
import org.nervos.mercury.model.resp.TxView;
import org.nervos.mercury.model.resp.info.DBInfo;
import org.nervos.mercury.model.resp.info.MercuryInfo;
import org.nervos.mercury.model.resp.info.MercurySyncState;

public class DefaultMercuryApi
extends DefaultIndexerApi
implements MercuryApi {
    private Gson g = GsonFactory.create();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        super(mercuryUrl, isDebug);
    }

    public DefaultMercuryApi(RpcService rpcService) {
        super(rpcService);
    }

    @Override
    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        GetBalanceResponse resp = (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(payload), GetBalanceResponse.class, this.g);
        return resp;
    }

    @Override
    public AccountInfo getAccountInfo(AccountInfoPayload payload) throws IOException {
        AccountInfo resp = (AccountInfo)this.rpcService.post("get_account_info", Arrays.asList(payload), AccountInfo.class, this.g);
        return resp;
    }

    @Override
    public TransactionWithScriptGroups buildTransferTransaction(TransferPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public TransactionWithScriptGroups buildSimpleTransferTransaction(SimpleTransferPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_simple_transfer_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public TransactionWithScriptGroups buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_adjust_account_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public GetTransactionInfoResponse getTransactionInfo(byte[] txHash) throws IOException {
        return (GetTransactionInfoResponse)this.rpcService.post("get_transaction_info", Arrays.asList(new byte[][]{txHash}), GetTransactionInfoResponse.class, this.g);
    }

    @Override
    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return (BlockInfoResponse)this.rpcService.post("get_block_info", Arrays.asList(payload), BlockInfoResponse.class, this.g);
    }

    @Override
    public List<byte[]> registerAddresses(List<String> normalAddresses) throws IOException {
        return (List)this.rpcService.post("register_addresses", Arrays.asList(normalAddresses), new TypeToken<List<String>>(){}.getType(), this.g);
    }

    @Override
    public PaginationResponse<TransactionWithRichStatus> queryTransactionsWithTransactionView(QueryTransactionsPayload payload) throws IOException {
        payload.structureType = StructureType.NATIVE;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TransactionWithRichStatus>>(){}.getType(), this.g);
    }

    @Override
    public PaginationResponse<TransactionInfoResponse> queryTransactionsWithTransactionInfo(QueryTransactionsPayload payload) throws IOException {
        payload.structureType = StructureType.DOUBLE_ENTRY;
        return (PaginationResponse)this.rpcService.post("query_transactions", Arrays.asList(payload), new TypeToken<PaginationResponse<TransactionInfoResponse>>(){}.getType(), this.g);
    }

    @Override
    public DBInfo getDbInfo() throws IOException {
        return (DBInfo)this.rpcService.post("get_db_info", Arrays.asList(new Object[0]), DBInfo.class);
    }

    @Override
    public MercuryInfo getMercuryInfo() throws IOException {
        return (MercuryInfo)this.rpcService.post("get_mercury_info", Arrays.asList(new Object[0]), MercuryInfo.class);
    }

    @Override
    public MercurySyncState getSyncState() throws IOException {
        return (MercurySyncState)this.rpcService.post("get_sync_state", Arrays.asList(new Object[0]), MercurySyncState.class);
    }

    @Override
    public TransactionWithScriptGroups buildDaoDepositTransaction(DaoDepositPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_dao_deposit_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public TransactionWithScriptGroups buildDaoWithdrawTransaction(DaoWithdrawPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_dao_withdraw_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public TransactionWithScriptGroups buildDaoClaimTransaction(DaoClaimPayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_dao_claim_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }

    @Override
    public TxView<TransactionWithRichStatus> getSpentTransactionWithTransactionView(GetSpentTransactionPayload payload) throws IOException {
        payload.structureType = StructureType.NATIVE;
        return (TxView)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), new TypeToken<TxView<TransactionWithRichStatus>>(){}.getType(), this.g);
    }

    @Override
    public TxView<TransactionInfoResponse> getSpentTransactionWithTransactionInfo(GetSpentTransactionPayload payload) throws IOException {
        payload.structureType = StructureType.DOUBLE_ENTRY;
        return (TxView)this.rpcService.post("get_spent_transaction", Arrays.asList(payload), new TypeToken<TxView<TransactionInfoResponse>>(){}.getType(), this.g);
    }

    @Override
    public TransactionWithScriptGroups buildSudtIssueTransaction(SudtIssuePayload payload) throws IOException {
        return (TransactionWithScriptGroups)this.rpcService.post("build_sudt_issue_transaction", Arrays.asList(payload), TransactionWithScriptGroups.class, this.g);
    }
}

