/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.req.item;

import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;
import org.nervos.mercury.model.req.item.Item;

public class ItemFactory {
    public static Item newAddressItem(String address) {
        return new Item(Item.Type.ADDRESS, address);
    }

    public static Item newIdentityItemByCkb(byte[] pubKeyHash) {
        if (pubKeyHash.length != 20) {
            throw new IllegalArgumentException("pubKeyHash length is not 20");
        }
        byte[] content = new byte[21];
        content[0] = 0;
        System.arraycopy(pubKeyHash, 0, content, 1, 20);
        return new Item(Item.Type.IDENTITY, Hex.toHexString((byte[])content));
    }

    public static Item newIdentityItemByCkb(String pubKeyHash) {
        return ItemFactory.newIdentityItemByCkb(Numeric.hexStringToByteArray((String)pubKeyHash));
    }

    public static Item newIdentityItemBySecp256k1Blake160SignhashAllAddress(String address) {
        Address addr = Address.decode((String)address);
        Script script = addr.getScript();
        if (!Arrays.equals(Script.SECP256_BLAKE160_SIGNHASH_ALL_CODE_HASH, script.codeHash)) {
            throw new IllegalArgumentException("address is not a SECP256_BLAKE160_SIGNHASH_ALL address");
        }
        if (script.hashType != Script.HashType.TYPE) {
            throw new IllegalArgumentException("address hash type should be TYPE");
        }
        return ItemFactory.newIdentityItemByCkb(script.args);
    }

    public static Item newOutPointItem(byte[] txHash, int index) {
        return ItemFactory.newOutPointItem(new OutPoint(txHash, index));
    }

    public static Item newOutPointItem(OutPoint outPoint) {
        return new Item(Item.Type.OUT_POINT, outPoint);
    }
}

