/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model;

import java.math.BigInteger;
import java.util.ArrayList;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.ToInfo;
import org.nervos.mercury.model.req.item.Item;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.req.since.SinceConfig;

public class TransferPayloadBuilder
extends TransferPayload {
    public TransferPayloadBuilder() {
        this.assetInfo = AssetInfo.newCkbAsset();
        this.feeRate = 1000L;
        this.to = new ArrayList();
    }

    public void addFrom(Item from) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        this.from.add(from);
    }

    public void assetInfo(AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
    }

    public void addTo(String address, BigInteger amount) {
        ToInfo toInfo = new ToInfo(address, amount);
        this.to.add(toInfo);
    }

    public void addTo(String address, long amount) {
        this.addTo(address, BigInteger.valueOf(amount));
    }

    public void payFee(TransferPayload.PayFee payFee) {
        this.payFee = payFee;
    }

    public void feeRate(Long feeRate) {
        this.feeRate = feeRate;
    }

    public void since(SinceConfig since) {
        this.since = since;
    }

    public TransferPayload build() {
        assert (this.from != null) : "from not null";
        assert (this.to != null) : "items not null";
        return this;
    }
}

