/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import constant.UdtHolder;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.Network;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Keys;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;
import org.nervos.mercury.model.AdjustAccountPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.item.ItemFactory;

public class BuildAdjustAccountTest {
    @Test
    void testCreateAsset() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        ECKeyPair keyPair = Keys.createEcKeyPair();
        Address newAddress = new Address(Script.generateSecp256K1Blake160SignhashAllScript((ECKeyPair)keyPair), Network.TESTNET);
        AddressWithKeyHolder.put(newAddress.encode(), Numeric.toHexString((byte[])keyPair.getEncodedPrivateKey()));
        AdjustAccountPayloadBuilder builder = new AdjustAccountPayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)Numeric.toHexString((byte[])newAddress.getScript().args)));
        builder.assetInfo(AssetInfo.newUdtAsset((byte[])UdtHolder.UDT_HASH));
        builder.addFrom(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey3()));
        builder.accountNumber(Integer.valueOf(1));
        builder.extraCkb(Long.valueOf(AmountUtils.ckbToShannon((long)200L)));
        TransactionWithScriptGroups s = ApiFactory.getApi().buildAdjustAccountTransaction(builder.build());
        Assertions.assertNotNull((Object)s.txView);
        Assertions.assertNotNull((Object)s.scriptGroups);
    }
}

