/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.common;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DaoInfo {
    public DaoState state;
    public long reward;

    @JsonAdapter(value=Serializer.class)
    public static class DaoState {
        public Type type;
        public List<Long> value;

        public static enum Type {
            DEPOSIT,
            WITHDRAW;

        }

        public static class Serializer
        implements JsonSerializer<DaoState>,
        JsonDeserializer<DaoState> {
            public JsonElement serialize(DaoState src, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
                JsonObject obj = new JsonObject();
                obj.add("type", context.serialize((Object)src.type, Type.class));
                List<Long> value = src.value;
                if (src.type == Type.WITHDRAW) {
                    obj.add("value", context.serialize(value, new TypeToken<List<Long>>(){}.getType()));
                } else if (src.type == Type.DEPOSIT) {
                    obj.add("value", context.serialize((Object)value.get(0), Long.class));
                } else {
                    throw new JsonParseException("Invalid type: " + (Object)((Object)src.type));
                }
                return obj;
            }

            public DaoState deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                DaoState daoState = new DaoState();
                daoState.type = (Type)((Object)context.deserialize(obj.get("type"), Type.class));
                if (daoState.type == Type.WITHDRAW) {
                    daoState.value = (List)context.deserialize(obj.get("value"), new TypeToken<List<Long>>(){}.getType());
                } else if (daoState.type == Type.DEPOSIT) {
                    Long value = (Long)context.deserialize(obj.get("value"), Long.class);
                    daoState.value = new ArrayList<Long>();
                    daoState.value.add(value);
                } else {
                    throw new JsonParseException("Invalid dao state type");
                }
                return daoState;
            }
        }
    }
}

