/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.mercury.model.QueryTransactionsPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.common.PaginationRequest;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.Range;
import org.nervos.mercury.model.req.item.ItemFactory;
import org.nervos.mercury.model.resp.TransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionWithRichStatus;
import org.nervos.mercury.model.resp.TxView;

public class QueryTransactionsTest {
    @Test
    void testQueryTransactionsView() throws IOException {
        QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
        builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.queryTransactionAddress()));
        builder.addAssetInfo(AssetInfo.newCkbAsset());
        builder.limit(Long.valueOf(2L));
        builder.order(PaginationRequest.Order.ASC);
        builder.range(new Range(2778100L, 3636218L));
        PaginationResponse resp1 = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
        Assertions.assertEquals((int)2, (int)resp1.response.size());
        Assertions.assertNotNull((Object)((TransactionWithRichStatus)((TxView)resp1.response.get((int)0)).value).transaction);
        Assertions.assertNotNull((Object)((TransactionWithRichStatus)((TxView)resp1.response.get((int)0)).value).txStatus);
        Assertions.assertNotNull((Object)((TxView)resp1.response.get((int)0)).type);
        PaginationResponse resp2 = ApiFactory.getApi().queryTransactionsWithTransactionInfo(builder.build());
        Assertions.assertEquals((int)2, (int)resp2.response.size());
        Assertions.assertNotNull((Object)((TransactionInfoResponse)((TxView)resp2.response.get((int)0)).value).burn);
        Assertions.assertNotNull((Object)((TransactionInfoResponse)((TxView)resp2.response.get((int)0)).value).records);
        Assertions.assertNotNull((Object)((TxView)resp2.response.get((int)0)).type);
    }

    @Test
    void testQueryTransactionsWithPage() throws IOException {
        QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
        builder.limit(Long.valueOf(1L));
        builder.returnCount(Boolean.valueOf(true));
        PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
        Assertions.assertEquals((int)1, (int)resp.response.size());
        QueryTransactionsPayloadBuilder builder2 = new QueryTransactionsPayloadBuilder();
        builder2.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
        builder2.limit(Long.valueOf(2L));
        builder2.returnCount(Boolean.valueOf(true));
        builder2.cursor(resp.nextCursor);
        resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder2.build());
        Assertions.assertEquals((int)2, (int)resp.response.size());
    }
}

