/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.req.item;

import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.nervos.ckb.Network;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;
import org.nervos.mercury.model.req.item.Item;

public class ItemFactory {
    public static Item newAddressItem(String address) {
        return new Item(Item.Type.ADDRESS, address);
    }

    public static Item newIdentityItemByCkb(byte[] pubKeyHash) {
        if (pubKeyHash.length != 20) {
            throw new IllegalArgumentException("pubKeyHash length is not 20");
        }
        byte[] content = new byte[21];
        content[0] = 0;
        System.arraycopy(pubKeyHash, 0, content, 1, 20);
        return new Item(Item.Type.IDENTITY, Hex.toHexString((byte[])content));
    }

    public static Item newIdentityItemByCkb(String pubKeyHash) {
        return ItemFactory.newIdentityItemByCkb(Numeric.hexStringToByteArray((String)pubKeyHash));
    }

    public static Item newIdentityItemBySecp256k1Blake160SignhashAllAddress(String address) {
        Script script = Address.decode((String)address).getScript();
        if (!Arrays.equals(Script.SECP256K1_BLAKE160_SIGNHASH_ALL_CODE_HASH, script.codeHash)) {
            throw new IllegalArgumentException("not a secp256k1_blake160_signhash_all address");
        }
        if (script.hashType != Script.HashType.TYPE) {
            throw new IllegalArgumentException("address hash type should be TYPE");
        }
        return ItemFactory.newIdentityItemByCkb(script.args);
    }

    public static Item newIdentityItemByAddress(String address) {
        Address a = Address.decode((String)address);
        if (!ItemFactory.isValidAddress(a)) {
            throw new IllegalArgumentException("not a valid secp256k1_blake160_signhash_all or ACP address");
        }
        byte[] args = new byte[20];
        System.arraycopy(a.getScript().args, 0, args, 0, 20);
        return ItemFactory.newIdentityItemByCkb(args);
    }

    private static boolean isValidAddress(Address address) {
        Script script = address.getScript();
        Network network = address.getNetwork();
        if (script.hashType != Script.HashType.TYPE) {
            return false;
        }
        return Arrays.equals(Script.SECP256K1_BLAKE160_SIGNHASH_ALL_CODE_HASH, script.codeHash) || Network.TESTNET == network && Arrays.equals(Script.ANY_CAN_PAY_CODE_HASH_TESTNET, script.codeHash) || Network.MAINNET == network && Arrays.equals(Script.ANY_CAN_PAY_CODE_HASH_MAINNET, script.codeHash);
    }

    public static Item newOutPointItem(byte[] txHash, int index) {
        return ItemFactory.newOutPointItem(new OutPoint(txHash, index));
    }

    public static Item newOutPointItem(OutPoint outPoint) {
        return new Item(Item.Type.OUT_POINT, outPoint);
    }
}

