/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.example.transaction.CellsWithPrivateKey;
import org.nervos.ckb.example.transaction.CollectUtils;
import org.nervos.ckb.example.transaction.Receiver;
import org.nervos.ckb.example.transaction.Sender;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.TransactionBuilder;

public class TransactionExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api = new Api("http://localhost:8114", false);
    private static List<KeyPair> KeyPairs = Arrays.asList(new KeyPair("08730a367dfabcadb805d69e0e613558d5160eb8bab9d6e326980c2c46a05db2", "ckt1qyqxgp7za7dajm5wzjkye52asc8fxvvqy9eqlhp82g"), new KeyPair("a202386cb9e46cecff9bc14b748b714c713075dd964c2507c8a8900540164959", "ckt1qyqtnz38fht9nvmrfdeunrhdtp29n0gagkps4duhek"), new KeyPair("89b773ec5cf97b8fd2cf280ab1e37cd658dc28d84bac8f8dda4a8646cc08d266", "ckt1qyqxvnycu7tdtyuejn3mmcnl4y09muxz8c3s2ewjd4"), new KeyPair("fec27185a66dd21abb97eeaaeb6bf63fb9c5b7c7966550e6798a78fbaf4197f0", "ckt1qyq8n3400g4lw7xs4denyjprpyzaa6z2z5wsl7e2gs"), new KeyPair("2cee134faa03a158011dff33b7756e89a0c76ba64006640615be7b483b2935b4", "ckt1qyqd4lgpt5auunu6s3wskkwxmdx548wksvcqyq44en"), new KeyPair("55b55c7bd177ed837dde45bbde12fc79c12fb8695be258064f40e6d5f65db96c", "ckt1qyqrlj6znd3uhvuln5z83epv54xu8pmphzgse5uylq"));

    public static void main(String[] args) throws Exception {
        String minerPrivateKey = "e79f3207ea4980b7fed79956d5934249ceac4751a4fae01a0f7c4a96884bc4e3";
        String minerAddress = "ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83";
        List<Receiver> receivers1 = Arrays.asList(new Receiver(TransactionExample.KeyPairs.get((int)0).address, new BigInteger("800").multiply(UnitCKB)), new Receiver(TransactionExample.KeyPairs.get((int)1).address, new BigInteger("900").multiply(UnitCKB)), new Receiver(TransactionExample.KeyPairs.get((int)2).address, new BigInteger("1000").multiply(UnitCKB)));
        BigInteger txFee = BigInteger.valueOf(10000L);
        System.out.println("Before transfer, miner's balance: " + TransactionExample.getBalance(minerAddress).divide(UnitCKB).toString(10) + " CKB");
        System.out.println("Before transfer, first receiver1's balance: " + TransactionExample.getBalance(TransactionExample.KeyPairs.get((int)0).address).divide(UnitCKB).toString(10) + " CKB");
        String hash = TransactionExample.sendCapacity(minerPrivateKey, receivers1, minerAddress, txFee);
        System.out.println("First transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transfer, first receiver1's balance: " + TransactionExample.getBalance(TransactionExample.KeyPairs.get((int)0).address).divide(UnitCKB).toString(10) + " CKB");
        List<Sender> senders1 = Arrays.asList(new Sender(TransactionExample.KeyPairs.get((int)0).privateKey, new BigInteger("500").multiply(UnitCKB)), new Sender(TransactionExample.KeyPairs.get((int)1).privateKey, new BigInteger("600").multiply(UnitCKB)), new Sender(TransactionExample.KeyPairs.get((int)2).privateKey, new BigInteger("700").multiply(UnitCKB)));
        List<Receiver> receivers2 = Arrays.asList(new Receiver(TransactionExample.KeyPairs.get((int)3).address, new BigInteger("400").multiply(UnitCKB)), new Receiver(TransactionExample.KeyPairs.get((int)4).address, new BigInteger("500").multiply(UnitCKB)), new Receiver(TransactionExample.KeyPairs.get((int)5).address, new BigInteger("600").multiply(UnitCKB)));
        String changeAddress = "ckt1qyqfnym6semhw2vzm33fjvk3ngxuf5433l9qz3af8a";
        System.out.println("Before transfer, first receiver2's balance: " + TransactionExample.getBalance(receivers2.get((int)0).address).divide(UnitCKB).toString(10) + " CKB");
        String hash2 = TransactionExample.sendCapacity(senders1, receivers2, changeAddress, txFee);
        System.out.println("Second transaction hash: " + hash2);
        Thread.sleep(30000L);
        System.out.println("After transfer, receiver2's balance: " + TransactionExample.getBalance(receivers2.get((int)0).address).divide(UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance(String address) throws IOException {
        CellCollector cellCollector = new CellCollector(api);
        return cellCollector.getCapacityWithAddress(address);
    }

    private static String sendCapacity(String privateKey, List<Receiver> receivers, String changeAddress, BigInteger fee) throws IOException {
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        List<Sender> senders = Collections.singletonList(new Sender(privateKey, needCapacity));
        return TransactionExample.sendCapacity(senders, receivers, changeAddress, fee);
    }

    private static String sendCapacity(List<Sender> senders, List<Receiver> receivers, String changeAddress, BigInteger fee) throws IOException {
        TransactionBuilder builder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellsWithPrivateKey> cellsWithPrivateKeys = txUtils.collectInputs(senders);
        for (CellsWithPrivateKey cellsWithPrivateKey : cellsWithPrivateKeys) {
            builder.addInputs(cellsWithPrivateKey.inputs);
        }
        builder.addOutputs(txUtils.generateOutputs(receivers, changeAddress, fee));
        builder.buildTx();
        int index = 0;
        for (CellsWithPrivateKey cellsWithPrivateKey : cellsWithPrivateKeys) {
            for (int i = 0; i < cellsWithPrivateKey.inputs.size(); ++i) {
                builder.signInput(index + i, cellsWithPrivateKey.privateKey);
            }
            index += cellsWithPrivateKey.inputs.size();
        }
        return api.sendTransaction(builder.getTransaction());
    }

    static class KeyPair {
        String privateKey;
        String address;

        KeyPair(String privateKey, String address) {
            this.privateKey = privateKey;
            this.address = address;
        }
    }
}

