/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.example.transaction.CellsWithPrivateKey;
import org.nervos.ckb.example.transaction.Receiver;
import org.nervos.ckb.example.transaction.Sender;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CollectedCells;
import org.nervos.ckb.transaction.Utils;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Network;
import org.nervos.ckb.utils.Numeric;

public class CollectUtils {
    private SystemScriptCell systemSecpCell;
    private Api api;
    private BigInteger collectedCapacity = BigInteger.ZERO;

    public CollectUtils(Api api) {
        this.api = api;
        try {
            this.systemSecpCell = Utils.getSystemScriptCell((Api)api);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<CellsWithPrivateKey> collectInputs(List<Sender> senders) throws IOException {
        ArrayList<CellsWithPrivateKey> cellsWithPrivateKeys = new ArrayList<CellsWithPrivateKey>();
        for (Sender sender : senders) {
            String lockHash = Utils.generateLockScriptWithPrivateKey((String)sender.privateKey, (String)this.systemSecpCell.cellHash).computeHash();
            CollectedCells collectedCells = new CellCollector(this.api).getCellInputs(lockHash, sender.capacity);
            if (collectedCells.capacity.compareTo(sender.capacity) < 0) {
                throw new IOException("No enough Capacity with sender private key: " + sender.privateKey);
            }
            this.collectedCapacity = this.collectedCapacity.add(collectedCells.capacity);
            cellsWithPrivateKeys.add(new CellsWithPrivateKey(collectedCells.inputs, sender.privateKey));
        }
        return cellsWithPrivateKeys;
    }

    public List<CellOutput> generateOutputs(List<Receiver> receivers, String changeAddress, BigInteger fee) throws IOException {
        if (fee.compareTo(BigInteger.ZERO) < 0) {
            throw new IOException("Transaction fee should not be smaller than zero");
        }
        ArrayList<CellOutput> cellOutputs = new ArrayList<CellOutput>();
        AddressUtils addressUtils = new AddressUtils(Network.TESTNET);
        for (Receiver receiver : receivers) {
            String blake160 = addressUtils.getBlake160FromAddress(receiver.address);
            cellOutputs.add(new CellOutput(receiver.capacity.toString(), new Script(this.systemSecpCell.cellHash, blake160, "type")));
        }
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        if (this.collectedCapacity.compareTo(needCapacity = needCapacity.add(fee)) > 0) {
            String string = addressUtils.getBlake160FromAddress(changeAddress);
            cellOutputs.add(new CellOutput(this.collectedCapacity.subtract(needCapacity).toString(), new Script(this.systemSecpCell.cellHash, Numeric.prependHexPrefix((String)string), "type")));
        }
        return cellOutputs;
    }
}

