/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.Hash;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CollectedCells;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.dynamic.Table;
import org.nervos.ckb.type.fixed.UInt64;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;

public class MultiSignTransactionExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api = new Api("http://localhost:8114", false);
    private static List<String> privateKeys = Arrays.asList("08730a367dfabcadb805d69e0e613558d5160eb8bab9d6e326980c2c46a05db2", "a202386cb9e46cecff9bc14b748b714c713075dd964c2507c8a8900540164959");
    private static List<String> publicKeys = Arrays.asList("32edb83018b57ddeb9bcc7287c5cc5da57e6e0289d31c9e98cb361e88678d6288", "33aeb3fdbfaac72e9e34c55884a401ee87115302c146dd9e314677d826375dc8f", "29a685b8206550ea1b600e347f18fd6115bffe582089d3567bec7eba57d04df01");
    private static Configuration configuration;
    private static SystemScriptCell systemMultiSigCell;
    private static SystemScriptCell systemSecpCell;

    public static void main(String[] args) throws Exception {
        systemSecpCell = SystemContract.getSystemSecpCell((Api)api);
        systemMultiSigCell = SystemContract.getSystemMultiSigCell((Api)api);
        configuration = new Configuration(0, 2, publicKeys);
        String multiSigAddress = configuration.address();
        String targetAddress = "ckt1qyqrlj6znd3uhvuln5z83epv54xu8pmphzgse5uylq";
        System.out.println("Before transferring, multi-sig address " + multiSigAddress + " balance is " + MultiSignTransactionExample.getMultiSigBalance().divide(UnitCKB).toString() + " CKB");
        String txHash = MultiSignTransactionExample.sendCapacity(targetAddress, UnitCKB.multiply(BigInteger.valueOf(6000L)), privateKeys, BigInteger.valueOf(10000L));
        System.out.println("Transaction hash: " + txHash);
        Thread.sleep(30000L);
        System.out.println("After transferring, multi-sig address " + multiSigAddress + " balance is " + MultiSignTransactionExample.getMultiSigBalance().divide(UnitCKB).toString() + " CKB");
    }

    public static BigInteger getMultiSigBalance() throws IOException {
        Script lock = MultiSignTransactionExample.generateLock();
        CellCollector cellCollector = new CellCollector(api);
        return cellCollector.getCapacityWithLockHash(lock.computeHash());
    }

    public static Transaction generateTx(String targetAddress, BigInteger capacity, List<String> privateKeys, BigInteger fee) throws IOException {
        if (privateKeys.size() != MultiSignTransactionExample.configuration.threshold) {
            throw new IOException("Invalid number of keys");
        }
        AddressUtils addressUtils = new AddressUtils(Network.TESTNET);
        CellOutput cellOutput = new CellOutput(Numeric.toHexString((String)capacity.toString()), new Script(MultiSignTransactionExample.systemSecpCell.cellHash, addressUtils.getArgsFromAddress(targetAddress), "type"));
        String outputData = "0x";
        CellOutput changeOutput = new CellOutput("0x0", MultiSignTransactionExample.generateLock());
        CellCollector cellCollector = new CellCollector(api);
        CollectedCells collectedCells = cellCollector.getCellInputs(MultiSignTransactionExample.generateLock().computeHash(), capacity);
        BigInteger inputCapacity = collectedCells.capacity;
        changeOutput.capacity = Numeric.toHexString((String)inputCapacity.subtract(capacity).subtract(fee).toString());
        Transaction transaction = new Transaction("0x0", Arrays.asList(new CellDep(MultiSignTransactionExample.systemMultiSigCell.outPoint, "dep_group"), new CellDep(MultiSignTransactionExample.systemSecpCell.outPoint, "dep_group")), Collections.emptyList(), collectedCells.inputs, Arrays.asList(cellOutput, changeOutput), Arrays.asList(outputData, outputData), collectedCells.witnesses);
        String txHash = transaction.computeHash();
        Blake2b blake2b = new Blake2b();
        blake2b.update(Numeric.hexStringToByteArray((String)txHash));
        StringBuilder emptySignature = new StringBuilder();
        for (int i = 0; i < privateKeys.size(); ++i) {
            emptySignature.append("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
        }
        Witness emptiedWitness = (Witness)transaction.witnesses.get(0);
        emptiedWitness.lock = configuration.serialize().concat(emptySignature.toString());
        Table table = Serializer.serializeWitnessArgs((Witness)emptiedWitness);
        blake2b.update(new UInt64(table.getLength()).toBytes());
        blake2b.update(table.toBytes());
        for (int i = 1; i < transaction.witnesses.size(); ++i) {
            byte[] bytes = transaction.witnesses.get(i).getClass() == Witness.class ? Serializer.serializeWitnessArgs((Witness)((Witness)transaction.witnesses.get(i))).toBytes() : Numeric.hexStringToByteArray((String)((String)transaction.witnesses.get(i)));
            blake2b.update(new UInt64(bytes.length).toBytes());
            blake2b.update(bytes);
        }
        String message = blake2b.doFinalString();
        StringBuilder concatenatedSignatures = new StringBuilder();
        for (String privateKey : privateKeys) {
            ECKeyPair ecKeyPair = ECKeyPair.createWithPrivateKey((String)privateKey, (boolean)false);
            concatenatedSignatures.append(Numeric.toHexStringNoPrefix((byte[])Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)message), (ECKeyPair)ecKeyPair).getSignature()));
        }
        ((Witness)transaction.witnesses.get((int)0)).lock = configuration.serialize().concat(concatenatedSignatures.toString());
        ArrayList<String> signedWitness = new ArrayList<String>();
        for (Object witness : transaction.witnesses) {
            if (witness.getClass() == Witness.class) {
                signedWitness.add(Numeric.toHexString((byte[])Serializer.serializeWitnessArgs((Witness)((Witness)witness)).toBytes()));
                continue;
            }
            signedWitness.add((String)witness);
        }
        transaction.witnesses = signedWitness;
        return transaction;
    }

    public static String sendCapacity(String targetAddress, BigInteger capacity, List<String> privateKeys, BigInteger fee) throws IOException {
        Transaction tx = MultiSignTransactionExample.generateTx(targetAddress, capacity, privateKeys, fee);
        return api.sendTransaction(tx);
    }

    public static Script generateLock() {
        return new Script(MultiSignTransactionExample.systemMultiSigCell.cellHash, Numeric.prependHexPrefix((String)configuration.blake160()), "type");
    }

    static class Configuration {
        int requireN;
        int threshold;
        List<String> publicKeys;

        Configuration(int requireN, int threshold, List<String> publicKeys) throws IOException {
            if (requireN < 0 || requireN > 255) {
                throw new IOException("requireN should be less than 256");
            }
            if (threshold < 0 || threshold > 255) {
                throw new IOException("threshold should be less than 256");
            }
            if (publicKeys.size() > 255) {
                throw new IOException("Public key number must be less than 256");
            }
            this.requireN = requireN;
            this.threshold = threshold;
            this.publicKeys = publicKeys;
        }

        String serialize() {
            StringBuilder multiSigBuffer = new StringBuilder();
            ArrayList bytes = new ArrayList();
            bytes.addAll(Numeric.intToBytes((int)0));
            bytes.addAll(Numeric.intToBytes((int)this.requireN));
            bytes.addAll(Numeric.intToBytes((int)this.threshold));
            bytes.addAll(Numeric.intToBytes((int)this.publicKeys.size()));
            multiSigBuffer.append(Numeric.toHexStringNoPrefix((byte[])Bytes.toArray(bytes)));
            for (String publicKey : this.publicKeys) {
                multiSigBuffer.append(Hash.blake160((String)publicKey));
            }
            return multiSigBuffer.toString();
        }

        public String blake160() {
            return Hash.blake160((String)this.serialize());
        }

        public String address() {
            AddressUtils addressUtils = new AddressUtils(Network.TESTNET, CodeHashType.MULTISIG);
            return addressUtils.generate(this.blake160());
        }
    }
}

