/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.address.AddressGenerator;

public class AddressGeneratorTest {
    @Test
    void testSingleSigShortTestnetAddressGenerate() {
        Script singleSigShortScript = new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        String address = AddressGenerator.generate((Network)Network.TESTNET, (Script)singleSigShortScript);
        Assertions.assertEquals((Object)"ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83", (Object)address);
    }

    @Test
    void testSingleSigShortMainnetAddressGenerate() {
        Script singleSigShortScript = new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        String address = AddressGenerator.generate((Network)Network.MAINNET, (Script)singleSigShortScript);
        Assertions.assertEquals((Object)"ckb1qyqrdsefa43s6m882pcj53m4gdnj4k440axqdt9rtd", (Object)address);
    }

    @Test
    void testMultiSigShortTestnetAddressGenerate() {
        Script multiSigShortScript = new Script("0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8", "0xf04cec84bc37f683613bed2f242c9aa1b678e9fe", "type");
        String address = AddressGenerator.generate((Network)Network.TESTNET, (Script)multiSigShortScript);
        Assertions.assertEquals((Object)"ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq", (Object)address);
    }

    @Test
    void testMultiSigShortMainnetAddressGenerate() {
        Script multiSigShortScript = new Script("0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8", "0xf04cec84bc37f683613bed2f242c9aa1b678e9fe", "type");
        String address = AddressGenerator.generate((Network)Network.MAINNET, (Script)multiSigShortScript);
        Assertions.assertEquals((Object)"ckb1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lq2sg8su", (Object)address);
    }

    @Test
    void testACPShortTestnetAddressGenerate() {
        Script acpShortScript = new Script("0x3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356", "0x81312ae06eeb0504b737e6bcfa5397be35a928de", "type");
        String address = AddressGenerator.generate((Network)Network.TESTNET, (Script)acpShortScript);
        Assertions.assertEquals((Object)"ckt1qypgzvf2uphwkpgykum7d0862wtmuddf9r0qnzefn9", (Object)address);
    }

    @Test
    void testACPShortMainnetAddressGenerate() {
        Script acpShortScript = new Script("0xd369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354", "0x81312ae06eeb0504b737e6bcfa5397be35a928de", "type");
        String address = AddressGenerator.generate((Network)Network.MAINNET, (Script)acpShortScript);
        Assertions.assertEquals((Object)"ckb1qypgzvf2uphwkpgykum7d0862wtmuddf9r0qw88kle", (Object)address);
    }

    @Test
    void testTypeFullTestnetAddressGenerate() {
        Script typeFullScript = new Script("0x1892ea40d82b53c678ff88312450bbb17e164d7a3e0a90941aa58839f56f8df2", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        String address = AddressGenerator.generateFullAddress((Network)Network.TESTNET, (Script)typeFullScript);
        Assertions.assertEquals((Object)"ckt1qsvf96jqmq4483ncl7yrzfzshwchu9jd0glq4yy5r2jcsw04d7xlydkr98kkxrtvuag8z2j8w4pkw2k6k4l5c02auef", (Object)address);
    }

    @Test
    void testBech32mTypeFullTestnetAddressGenerate() {
        Script fullScript = new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0xb39bbc0b3673c7d36450bc14cfcdad2d559c6c64", "type");
        String address = AddressGenerator.generateBech32mFullAddress((Network)Network.MAINNET, (Script)fullScript);
        Assertions.assertEquals((Object)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdnnw7qkdnnclfkg59uzn8umtfd2kwxceqxwquc4", (Object)address);
    }

    @Test
    void testTypeFullMainnetAddressGenerate() {
        Script typeFullScript = new Script("0x1892ea40d82b53c678ff88312450bbb17e164d7a3e0a90941aa58839f56f8df2", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        String address = AddressGenerator.generateFullAddress((Network)Network.MAINNET, (Script)typeFullScript);
        Assertions.assertEquals((Object)"ckb1qsvf96jqmq4483ncl7yrzfzshwchu9jd0glq4yy5r2jcsw04d7xlydkr98kkxrtvuag8z2j8w4pkw2k6k4l5czfy37k", (Object)address);
    }

    @Test
    void testDataFullTestnetAddressGenerate() {
        Script dataFullScript = new Script("0xa656f172b6b45c245307aeb5a7a37a176f002f6f22e92582c58bf7ba362e4176", "0x36c329ed630d6ce750712a477543672adab57f4c", "data");
        String address = AddressGenerator.generateFullAddress((Network)Network.TESTNET, (Script)dataFullScript);
        Assertions.assertEquals((Object)"ckt1q2n9dutjk669cfznq7httfar0gtk7qp0du3wjfvzck9l0w3k9eqhvdkr98kkxrtvuag8z2j8w4pkw2k6k4l5czshhac", (Object)address);
    }

    @Test
    void testDataFullMainnetAddressGenerate() {
        Script dataFullScript = new Script("0xa656f172b6b45c245307aeb5a7a37a176f002f6f22e92582c58bf7ba362e4176", "0x36c329ed630d6ce750712a477543672adab57f4c", "data");
        String address = AddressGenerator.generateFullAddress((Network)Network.MAINNET, (Script)dataFullScript);
        Assertions.assertEquals((Object)"ckb1q2n9dutjk669cfznq7httfar0gtk7qp0du3wjfvzck9l0w3k9eqhvdkr98kkxrtvuag8z2j8w4pkw2k6k4l5c0nw668", (Object)address);
    }
}

