/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.math.BigInteger;
import org.nervos.ckb.type.dynamic.Table;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Serializer;

public class Calculator {
    private static final int SERIALIZED_TX_OFFSET_BYTE_SIZE = 4;
    private static final BigInteger RADIO = BigInteger.valueOf(1000L);

    public static int calculateTransactionSize(Transaction transaction) {
        Table serializedTx = Serializer.serializeTransaction(transaction);
        return serializedTx.getLength() + 4;
    }

    private static BigInteger calculateTransactionFee(BigInteger transactionSize, BigInteger feeRate) {
        BigInteger base = transactionSize.multiply(feeRate);
        BigInteger fee = base.divide(RADIO);
        if (fee.multiply(RADIO).compareTo(base) < 0) {
            return fee.add(BigInteger.ONE);
        }
        return fee;
    }

    public static BigInteger calculateTransactionFee(Transaction transaction, BigInteger feeRate) {
        BigInteger txSize = BigInteger.valueOf(Calculator.calculateTransactionSize(transaction));
        return Calculator.calculateTransactionFee(txSize, feeRate);
    }
}

