/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.gson.Gson;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressTools;

public class AddressToolsTest {
    @Test
    void testGenerateShortAddress() {
        try {
            System.out.println(new Gson().toJson((Object)AddressTools.generateShortAddress((Network)Network.TESTNET)));
            System.out.println(new Gson().toJson((Object)AddressTools.generateShortAddress((Network)Network.MAINNET)));
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGenerateFullAddress() {
        try {
            AddressTools.AddressGenerateResult address = AddressTools.generateFullAddress((Network)Network.TESTNET);
            AddressTools.parse((String)address.address);
            address = AddressTools.generateFullAddress((Network)Network.MAINNET);
            AddressTools.parse((String)address.address);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testConvertPublicKeyToAddress() {
        try {
            String shortAddress1 = AddressTools.convertPublicKeyToShortAddress((Network)Network.TESTNET, (String)"0x24a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01");
            String shortAddress2 = AddressTools.convertPublicKeyToShortAddress((Network)Network.TESTNET, (String)"24a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01");
            String fullAddress1 = AddressTools.convertPublicKeyToFullAddress((Network)Network.TESTNET, (String)"0x24a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01");
            String fullAddress2 = AddressTools.convertPublicKeyToFullAddress((Network)Network.TESTNET, (String)"24a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01");
            System.out.println(shortAddress1);
            System.out.println(fullAddress1);
            System.out.println("comparation result - short address: " + shortAddress1.equals(shortAddress2) + ", full address: " + fullAddress1.equals(fullAddress2));
            AddressTools.parse((String)shortAddress1);
            AddressTools.parse((String)fullAddress1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGenerateAcpAddress() {
        String expected = "ckt1qypqtg06h75ymw098r3w0l3u4xklsj04tnsqkm65q6";
        String address = "ckt1qyqqtg06h75ymw098r3w0l3u4xklsj04tnsqctqrmc";
        String actual = AddressTools.generateAcpAddress((String)address);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testGenerateChequeAddress() {
        String expected = "ckt1q3sdtuu7lnjqn3v8ew02xkwwlh4dv5x2z28shkwt8p2nfruccux4k5kw5xmckqjq7gwpe990sn88xssv96try4l46hu6nnudr2huau238a4prwus9pqts3uptms";
        String senderAddress = "ckt1qyq27z6pccncqlaamnh8ttapwn260egnt67ss2cwvz";
        String receiverAddress = "ckt1qyqqtg06h75ymw098r3w0l3u4xklsj04tnsqctqrmc";
        String actual = AddressTools.generateChequeAddress((String)senderAddress, (String)receiverAddress);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testParseAddress() {
        String address = "ckt1qyqqtg06h75ymw098r3w0l3u4xklsj04tnsqctqrmc";
        AddressParseResult script = AddressTools.parse((String)address);
        System.out.println(new Gson().toJson((Object)script));
    }

    @Test
    void testParseNetwork() {
        String address = "ckt1qyqqtg06h75ymw098r3w0l3u4xklsj04tnsqctqrmc";
        Assertions.assertEquals((Object)Network.TESTNET, (Object)AddressTools.parseNetwork((String)address));
    }
}

