/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils.address;

import com.google.common.primitives.Bytes;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.exceptions.AddressFormatException;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Bech32;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.address.AddressBaseOperator;
import org.nervos.ckb.utils.address.AddressParseResult;

public class AddressParser
extends AddressBaseOperator {
    private static String parsePayload(String address) {
        Bech32.Bech32Data parsed = Bech32.decode((String)address);
        byte[] data = AddressParser.convertBits(Bytes.asList((byte[])parsed.data), 5, 8, false);
        if (data.length == 0) {
            return null;
        }
        Bech32.Bech32Data bech32Data = new Bech32.Bech32Data(parsed.hrp, data);
        return Numeric.toHexStringNoPrefix((byte[])bech32Data.data);
    }

    public static AddressParseResult parse(String address) throws AddressFormatException {
        String payload = AddressParser.parsePayload(address);
        if (payload == null) {
            throw new AddressFormatException("Address bech32 decode fail");
        }
        String type = payload.substring(0, 2);
        Network network = AddressParser.parseNetwork(address);
        if ("01".equals(type)) {
            String codeHashIndex = payload.substring(2, 4);
            String args = Numeric.prependHexPrefix((String)payload.substring(4));
            if (!codeHashIndex.equals("02") && Numeric.cleanHexPrefix((String)args).length() / 2 != 20) {
                throw new AddressFormatException("Short address args byte length must be equal to 20");
            }
            switch (codeHashIndex) {
                case "00": {
                    return new AddressParseResult(network, new Script(Numeric.prependHexPrefix((String)"9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8"), args, "type"), AddressParseResult.Type.SHORT);
                }
                case "01": {
                    return new AddressParseResult(network, new Script(Numeric.prependHexPrefix((String)"5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8"), args, "type"), AddressParseResult.Type.SHORT);
                }
                case "02": {
                    String codeHash = Numeric.prependHexPrefix((String)(network == Network.MAINNET ? "d369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354" : "3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356"));
                    return new AddressParseResult(network, new Script(codeHash, args, "type"), AddressParseResult.Type.SHORT);
                }
            }
            throw new AddressFormatException("Short address code hash index must be 00, 01 or 02");
        }
        if (payload.length() < 66) {
            throw new AddressFormatException("Invalid full address payload length");
        }
        if ("02".equals(type)) {
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String args = Numeric.prependHexPrefix((String)payload.substring(66));
            return new AddressParseResult(network, new Script(codeHash, args, "data"), AddressParseResult.Type.FULL);
        }
        if ("04".equals(type)) {
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String args = Numeric.prependHexPrefix((String)payload.substring(66));
            return new AddressParseResult(network, new Script(codeHash, args, "type"), AddressParseResult.Type.FULL);
        }
        if ("00".equals(type)) {
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String hashType = Serializer.deserializeHashType(payload.substring(66, 68));
            String args = Numeric.prependHexPrefix((String)payload.substring(68));
            return new AddressParseResult(network, new Script(codeHash, args, hashType), AddressParseResult.Type.FULL);
        }
        throw new AddressFormatException("Full address type must be 02 or 04");
    }

    public static Network parseNetwork(String address) {
        if (address.startsWith("ckb")) {
            return Network.MAINNET;
        }
        if (address.startsWith("ckt")) {
            return Network.TESTNET;
        }
        throw new AddressFormatException("Address prefix should be ckb or ckt");
    }
}

