/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type.transaction;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.Encoder;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.type.base.Type;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;

public class Transaction {
    public String version;
    public String hash;
    @SerializedName(value="cell_deps")
    public List<CellDep> cellDeps;
    @SerializedName(value="header_deps")
    public List<String> headerDeps;
    public List<CellInput> inputs;
    public List<CellOutput> outputs;
    @SerializedName(value="outputs_data")
    public List<String> outputsData;
    public List<String> witnesses;

    public Transaction() {
    }

    public Transaction(String version, List<CellDep> cellDeps, List<String> headerDeps, List<CellInput> cellInputs, List<CellOutput> cellOutputs, List<String> outputsData, List<String> witnesses) {
        this.version = version;
        this.cellDeps = cellDeps;
        this.headerDeps = headerDeps;
        this.inputs = cellInputs;
        this.outputs = cellOutputs;
        this.outputsData = outputsData;
        this.witnesses = witnesses;
    }

    public Transaction(String version, String hash, List<CellDep> cellDeps, List<String> headerDeps, List<CellInput> cellInputs, List<CellOutput> cellOutputs, List<String> outputsData, List<String> witnesses) {
        this.version = version;
        this.hash = hash;
        this.cellDeps = cellDeps;
        this.headerDeps = headerDeps;
        this.inputs = cellInputs;
        this.outputs = cellOutputs;
        this.outputsData = outputsData;
        this.witnesses = witnesses;
    }

    public String computeHash() {
        Blake2b blake2b = new Blake2b();
        blake2b.update(Encoder.encode((Type)Serializer.serializeTransaction(this)));
        return blake2b.doFinalString();
    }

    public Transaction sign(BigInteger privateKey) {
        if (this.witnesses.size() < this.inputs.size()) {
            throw new RuntimeException("Invalid number of witnesses");
        }
        String txHash = this.computeHash();
        ECKeyPair ecKeyPair = ECKeyPair.createWithPrivateKey((BigInteger)privateKey, (boolean)false);
        ArrayList<String> signedWitnesses = new ArrayList<String>();
        for (String witness : this.witnesses) {
            Blake2b blake2b = new Blake2b();
            blake2b.update(Numeric.hexStringToByteArray((String)txHash));
            blake2b.update(Numeric.hexStringToByteArray((String)witness));
            String message = blake2b.doFinalString();
            String signature = Numeric.toHexString((byte[])Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)message), (ECKeyPair)ecKeyPair).getSignature());
            signedWitnesses.add(signature + Numeric.cleanHexPrefix((String)witness));
        }
        return new Transaction(this.version, txHash, this.cellDeps, this.headerDeps, this.inputs, this.outputs, this.outputsData, signedWitnesses);
    }
}

