/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import com.google.gson.annotations.SerializedName;
import org.nervos.ckb.Encoder;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.type.base.Type;
import org.nervos.ckb.utils.Serializer;

public class Script {
    public static final String DATA = "data";
    public static final String TYPE = "type";
    @SerializedName(value="code_hash")
    public String codeHash;
    public String args;
    @SerializedName(value="hash_type")
    public String hashType;

    public Script() {
    }

    public Script(String codeHash, String args) {
        this.codeHash = codeHash;
        this.args = args;
        this.hashType = DATA;
    }

    public Script(String codeHash, String args, String hashType) {
        this.codeHash = codeHash;
        this.args = args;
        this.hashType = hashType;
    }

    public String computeHash() {
        Blake2b blake2b = new Blake2b();
        blake2b.update(Encoder.encode((Type)Serializer.serializeScript(this)));
        return blake2b.doFinalString();
    }
}

