/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.type.BannedAddress;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.BlockchainInfo;
import org.nervos.ckb.type.CellbaseOutputCapacity;
import org.nervos.ckb.type.Cycles;
import org.nervos.ckb.type.Epoch;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.LockHashIndexState;
import org.nervos.ckb.type.NodeInfo;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.TxPoolInfo;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.transaction.Transaction;

@Disabled
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiTest {
    private Api api;

    @BeforeAll
    public void init() {
        this.api = new Api("http://localhost:8114", false);
    }

    @Test
    public void testGetBlockByNumber() throws IOException {
        Block block = this.api.getBlockByNumber("0x1");
        Assertions.assertNotNull((Object)block);
    }

    @Test
    public void testGetBlockHashByNumber() throws IOException {
        String blockHash = this.api.getBlockHash("0x1");
        Assertions.assertNotNull((Object)blockHash);
    }

    @Test
    public void testGetCellbaseOutputCapacityDetails() throws IOException {
        String blockHash = this.api.getBlockHash("0x1");
        CellbaseOutputCapacity cellbaseOutputCapacity = this.api.getCellbaseOutputCapacityDetails(blockHash);
        Assertions.assertNotNull((Object)cellbaseOutputCapacity);
    }

    @Test
    public void testBlockAndTransaction() throws IOException {
        String blockHash = this.api.getBlockHash("0x1");
        Block block = this.api.getBlock(blockHash);
        Assertions.assertNotNull((Object)block);
        Assertions.assertNotNull((Object)block.header);
    }

    @Test
    public void testTransaction() throws IOException {
        String transactionHash = ((Transaction)this.api.getBlockByNumber((String)"0x1").transactions.get((int)0)).hash;
        Transaction transaction = this.api.getTransaction((String)transactionHash).transaction;
        Assertions.assertNotNull((Object)transaction);
    }

    @Test
    public void testGetTipHeader() throws IOException {
        Header header = this.api.getTipHeader();
        Assertions.assertNotNull((Object)header);
    }

    @Test
    public void testGetTipBlockNumber() throws IOException {
        BigInteger blockNumber = this.api.getTipBlockNumber();
        Assertions.assertNotNull((Object)blockNumber.toString());
    }

    @Test
    public void testGetCurrentEpoch() throws IOException {
        Epoch epoch = this.api.getCurrentEpoch();
        Assertions.assertNotNull((Object)epoch);
    }

    @Test
    public void testGetEpochByNumber() throws IOException {
        Epoch epoch = this.api.getEpochByNumber("0");
        Assertions.assertNotNull((Object)epoch);
    }

    @Test
    public void testGetHeader() throws IOException {
        String blockHash = this.api.getBlockHash("0x1");
        Header header = this.api.getHeader(blockHash);
        Assertions.assertNotNull((Object)header);
    }

    @Test
    public void testGetHeaderByNumber() throws IOException {
        Header header = this.api.getHeaderByNumber("0x1");
        Assertions.assertNotNull((Object)header);
    }

    @Test
    public void localNodeInfo() throws IOException {
        NodeInfo nodeInfo = this.api.localNodeInfo();
        Assertions.assertNotNull((Object)nodeInfo);
    }

    @Test
    public void getPeers() throws IOException {
        List peers = this.api.getPeers();
        Assertions.assertNotNull((Object)peers);
    }

    @Test
    public void testSetBan() throws IOException {
        BannedAddress bannedAddress = new BannedAddress("192.168.0.2", "insert", "1840546800000", true, "test set_ban rpc");
        String banResult = this.api.setBan(bannedAddress);
        Assertions.assertNull((Object)banResult);
    }

    @Test
    public void testGetBannedAddress() throws IOException {
        List bannedAddresses = this.api.getBannedAddress();
        Assertions.assertNotNull((Object)bannedAddresses);
    }

    @Test
    public void txPoolInfo() throws IOException {
        TxPoolInfo txPoolInfo = this.api.txPoolInfo();
        Assertions.assertNotNull((Object)txPoolInfo);
    }

    @Test
    public void testGetBlockchainInfo() throws IOException {
        BlockchainInfo blockchainInfo = this.api.getBlockchainInfo();
        Assertions.assertNotNull((Object)blockchainInfo);
    }

    @Test
    public void testGetPeersState() throws IOException {
        List peerStates = this.api.getPeersState();
        Assertions.assertNotNull((Object)peerStates);
    }

    @Test
    public void testGetCellsByLockHash() throws IOException {
        List cellOutputWithOutPoints = this.api.getCellsByLockHash("0xecaeea8c8581d08a3b52980272001dbf203bc6fa2afcabe7cc90cc2afff488ba", "0", "100");
        Assertions.assertTrue((cellOutputWithOutPoints.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetLiveCell() throws IOException {
        CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint("0xde7ac423660b95df1fd8879a54a98020bcbb30fc9bfcf13da757e99b30effd8d", "0"), true);
        Assertions.assertNotNull((Object)cellWithStatus);
    }

    @Test
    public void testGetLiveCellWithData() throws IOException {
        CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint("0xde7ac423660b95df1fd8879a54a98020bcbb30fc9bfcf13da757e99b30effd8d", "0"), true);
        Assertions.assertNotNull((Object)cellWithStatus.cell.data);
    }

    @Test
    public void testGetLiveCellWithoutData() throws IOException {
        CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint("0xde7ac423660b95df1fd8879a54a98020bcbb30fc9bfcf13da757e99b30effd8d", "0"), false);
        Assertions.assertNull((Object)cellWithStatus.cell.data);
    }

    @Test
    public void testSendTransaction() throws IOException {
        String transactionHash = this.api.sendTransaction(new Transaction("0", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        Assertions.assertNotNull((Object)transactionHash);
    }

    @Test
    public void testDryRunTransaction() throws IOException {
        Cycles cycles = this.api.dryRunTransaction(new Transaction("0", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        Assertions.assertNotNull((Object)cycles);
    }

    @Test
    public void testComputeTransactionHash() throws IOException {
        String transactionHash = this.api.computeTransactionHash(new Transaction("0", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        Assertions.assertNotNull((Object)transactionHash);
    }

    @Test
    public void testIndexLockHash() throws IOException {
        LockHashIndexState lockHashIndexState = this.api.indexLockHash("0x59d90b1718471f5802de59501604100a5e3b463865cdfe56fa70ed23865ee32e");
        Assertions.assertNotNull((Object)lockHashIndexState);
    }

    @Test
    public void testIndexLockHashWithBlockNumber() throws IOException {
        LockHashIndexState lockHashIndexState = this.api.indexLockHash("0x59d90b1718471f5802de59501604100a5e3b463865cdfe56fa70ed23865ee32e", "0");
        Assertions.assertNotNull((Object)lockHashIndexState);
    }

    @Test
    public void testDeindexLockHash() throws IOException {
        List lockHashs = this.api.deindexLockHash("0x59d90b1718471f5802de59501604100a5e3b463865cdfe56fa70ed23865ee32e");
        Assertions.assertNull((Object)lockHashs);
    }

    @Test
    public void testGetLockHashIndexStates() throws IOException {
        List lockHashIndexStates = this.api.getLockHashIndexStates();
        Assertions.assertNotNull((Object)lockHashIndexStates);
    }

    @Test
    public void testGetLiveCellsByLockHash() throws IOException {
        List liveCells = this.api.getLiveCellsByLockHash("0xecaeea8c8581d08a3b52980272001dbf203bc6fa2afcabe7cc90cc2afff488ba", "0", "100", false);
        Assertions.assertNotNull((Object)liveCells);
    }

    @Test
    public void testGetTransactionsByLockHash() throws IOException {
        List cellTransactions = this.api.getTransactionsByLockHash("0xecaeea8c8581d08a3b52980272001dbf203bc6fa2afcabe7cc90cc2afff488ba", "0", "100", false);
        Assertions.assertNotNull((Object)cellTransactions);
    }
}

