/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.type.BannedAddress;
import org.nervos.ckb.type.BannedResultAddress;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.BlockchainInfo;
import org.nervos.ckb.type.CellbaseOutputCapacity;
import org.nervos.ckb.type.Cycles;
import org.nervos.ckb.type.Epoch;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.LockHashIndexState;
import org.nervos.ckb.type.NodeInfo;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.PeerState;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.TxPoolInfo;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.cell.CellTransaction;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.cell.LiveCell;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.type.transaction.TransactionWithStatus;
import org.nervos.ckb.utils.Convert;
import org.nervos.ckb.utils.Numeric;

public class Api {
    private RpcService rpcService;

    public Api(String nodeUrl) {
        this(nodeUrl, false);
    }

    public Api(String nodeUrl, boolean isDebug) {
        this.rpcService = new RpcService(nodeUrl, isDebug);
    }

    public Block getBlock(String blockHash) throws IOException {
        return (Block)this.rpcService.post("get_block", Collections.singletonList(blockHash), (Type)((Object)Block.class));
    }

    public Block getBlockByNumber(String blockNumber) throws IOException {
        return (Block)this.rpcService.post("get_block_by_number", Collections.singletonList(Numeric.toHexString((String)blockNumber)), (Type)((Object)Block.class));
    }

    public TransactionWithStatus getTransaction(String transactionHash) throws IOException {
        return (TransactionWithStatus)this.rpcService.post("get_transaction", Collections.singletonList(transactionHash), (Type)((Object)TransactionWithStatus.class));
    }

    public String getBlockHash(String blockNumber) throws IOException {
        return (String)this.rpcService.post("get_block_hash", Collections.singletonList(Numeric.toHexString((String)blockNumber)), (Type)((Object)String.class));
    }

    public CellbaseOutputCapacity getCellbaseOutputCapacityDetails(String blockHash) throws IOException {
        return (CellbaseOutputCapacity)this.rpcService.post("get_cellbase_output_capacity_details", Collections.singletonList(blockHash), (Type)((Object)CellbaseOutputCapacity.class));
    }

    public Header getTipHeader() throws IOException {
        return (Header)this.rpcService.post("get_tip_header", Collections.emptyList(), (Type)((Object)Header.class));
    }

    public List<CellOutputWithOutPoint> getCellsByLockHash(String lockHash, String fromBlockNumber, String toBlockNumber) throws IOException {
        return (List)this.rpcService.post("get_cells_by_lock_hash", Arrays.asList(lockHash, Numeric.toHexString((String)fromBlockNumber), Numeric.toHexString((String)toBlockNumber)), new TypeToken<List<CellOutputWithOutPoint>>(){}.getType());
    }

    public CellWithStatus getLiveCell(OutPoint outPoint, boolean withData) throws IOException {
        return (CellWithStatus)this.rpcService.post("get_live_cell", Arrays.asList(Convert.parseOutPoint(outPoint), withData), (Type)((Object)CellWithStatus.class));
    }

    public BigInteger getTipBlockNumber() throws IOException {
        String blockNumber = (String)this.rpcService.post("get_tip_block_number", Collections.emptyList(), (Type)((Object)String.class));
        return Numeric.toBigInt((String)blockNumber);
    }

    public Epoch getCurrentEpoch() throws IOException {
        return (Epoch)this.rpcService.post("get_current_epoch", Collections.emptyList(), (Type)((Object)Epoch.class));
    }

    public Epoch getEpochByNumber(String epochNumber) throws IOException {
        return (Epoch)this.rpcService.post("get_epoch_by_number", Collections.singletonList(Numeric.toHexString((String)epochNumber)), (Type)((Object)Epoch.class));
    }

    public Header getHeader(String blockHash) throws IOException {
        return (Header)this.rpcService.post("get_header", Collections.singletonList(blockHash), (Type)((Object)Header.class));
    }

    public Header getHeaderByNumber(String blockNumber) throws IOException {
        return (Header)this.rpcService.post("get_header_by_number", Collections.singletonList(Numeric.toHexString((String)blockNumber)), (Type)((Object)Header.class));
    }

    public BlockchainInfo getBlockchainInfo() throws IOException {
        return (BlockchainInfo)this.rpcService.post("get_blockchain_info", Collections.emptyList(), (Type)((Object)BlockchainInfo.class));
    }

    public List<PeerState> getPeersState() throws IOException {
        return (List)this.rpcService.post("get_peers_state", Collections.emptyList(), new TypeToken<List<PeerState>>(){}.getType());
    }

    public String setBan(BannedAddress bannedAddress) throws IOException {
        return (String)this.rpcService.post("set_ban", Collections.singletonList(bannedAddress), (Type)((Object)String.class));
    }

    public List<BannedResultAddress> getBannedAddress() throws IOException {
        return (List)this.rpcService.post("get_banned_address", Collections.emptyList(), new TypeToken<List<BannedResultAddress>>(){}.getType());
    }

    public TxPoolInfo txPoolInfo() throws IOException {
        return (TxPoolInfo)this.rpcService.post("tx_pool_info", Collections.emptyList(), (Type)((Object)TxPoolInfo.class));
    }

    public String sendTransaction(Transaction transaction) throws IOException {
        return (String)this.rpcService.post("send_transaction", Collections.singletonList(Convert.parseTransaction(transaction)), (Type)((Object)String.class));
    }

    public NodeInfo localNodeInfo() throws IOException {
        return (NodeInfo)this.rpcService.post("local_node_info", Collections.emptyList(), (Type)((Object)NodeInfo.class));
    }

    public List<NodeInfo> getPeers() throws IOException {
        return (List)this.rpcService.post("get_peers", Collections.emptyList(), new TypeToken<List<NodeInfo>>(){}.getType());
    }

    public Cycles dryRunTransaction(Transaction transaction) throws IOException {
        return (Cycles)this.rpcService.post("dry_run_transaction", Collections.singletonList(Convert.parseTransaction(transaction)), (Type)((Object)Cycles.class));
    }

    public String computeTransactionHash(Transaction transaction) throws IOException {
        return (String)this.rpcService.post("_compute_transaction_hash", Collections.singletonList(Convert.parseTransaction(transaction)), (Type)((Object)String.class));
    }

    public String computeScriptHash(Script script) throws IOException {
        return (String)this.rpcService.post("_compute_script_hash", Collections.singletonList(script), (Type)((Object)String.class));
    }

    public LockHashIndexState indexLockHash(String lockHash) throws IOException {
        return (LockHashIndexState)this.rpcService.post("index_lock_hash", Collections.singletonList(lockHash), (Type)((Object)LockHashIndexState.class));
    }

    public LockHashIndexState indexLockHash(String lockHash, String indexFrom) throws IOException {
        return (LockHashIndexState)this.rpcService.post("index_lock_hash", Arrays.asList(lockHash, Numeric.toHexString((String)indexFrom)), (Type)((Object)LockHashIndexState.class));
    }

    public List<String> deindexLockHash(String lockHash) throws IOException {
        return (List)this.rpcService.post("deindex_lock_hash", Collections.singletonList(lockHash), new TypeToken<List<String>>(){}.getType());
    }

    public List<LockHashIndexState> getLockHashIndexStates() throws IOException {
        return (List)this.rpcService.post("get_lock_hash_index_states", Collections.emptyList(), new TypeToken<List<LockHashIndexState>>(){}.getRawType());
    }

    public List<LiveCell> getLiveCellsByLockHash(String lockHash, String page, String pageSize, boolean reverseOrder) throws IOException {
        return (List)this.rpcService.post("get_live_cells_by_lock_hash", Arrays.asList(lockHash, Numeric.toHexString((String)page), Numeric.toHexString((String)pageSize), reverseOrder), new TypeToken<List<LiveCell>>(){}.getType());
    }

    public List<CellTransaction> getTransactionsByLockHash(String lockHash, String page, String pageSize, boolean reverseOrder) throws IOException {
        return (List)this.rpcService.post("get_transactions_by_lock_hash", Arrays.asList(lockHash, Numeric.toHexString((String)page), Numeric.toHexString((String)pageSize), reverseOrder), new TypeToken<List<CellTransaction>>(){}.getType());
    }
}

