/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.nervos.ckb.service.RpcCallback;

class RpcService {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private static AtomicLong nextId = new AtomicLong(0L);
    private OkHttpClient client;
    private String url;
    private Gson gson;

    RpcService(String nodeUrl, boolean isDebug) {
        this.url = nodeUrl;
        if (isDebug) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.level(HttpLoggingInterceptor.Level.BODY);
            this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)logging).build();
        } else {
            this.client = new OkHttpClient();
        }
        this.gson = new Gson();
    }

    <T> T post(@NotNull String method, List params, Type cls) throws IOException {
        RequestParams requestParams = new RequestParams(method, params);
        RequestBody body = RequestBody.create((String)this.gson.toJson((Object)requestParams), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(this.url).post(body).build();
        Response response = this.client.newCall(request).execute();
        if (response.isSuccessful()) {
            String responseBody = response.body().string();
            RpcResponse rpcResponse = (RpcResponse)this.gson.fromJson(responseBody, new TypeToken<RpcResponse>(){}.getType());
            if (rpcResponse.error != null) {
                throw new IOException("RpcService method " + method + " error " + this.gson.toJson((Object)rpcResponse.error));
            }
            JsonElement jsonElement = new JsonParser().parse(responseBody).getAsJsonObject().get("result");
            if (jsonElement.isJsonObject()) {
                return (T)this.gson.fromJson((JsonElement)jsonElement.getAsJsonObject(), cls);
            }
            return (T)this.gson.fromJson(jsonElement, cls);
        }
        throw new IOException("RpcService method " + method + " error code " + response.code());
    }

    <T> void postAsync(final @NotNull String method, List params, final @NotNull Type cls, final @NotNull RpcCallback<T> callback) {
        RequestParams requestParams = new RequestParams(method, params);
        RequestBody body = RequestBody.create((String)this.gson.toJson((Object)requestParams), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(this.url).post(body).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                callback.onFailure(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                JsonElement jsonElement;
                if (response.isSuccessful()) {
                    String responseBody = response.body().string();
                    RpcResponse rpcResponse = (RpcResponse)RpcService.this.gson.fromJson(responseBody, new TypeToken<RpcResponse<T>>(){}.getType());
                    if (rpcResponse.error != null) {
                        throw new IOException("RpcService method " + method + " error " + RpcService.this.gson.toJson((Object)rpcResponse.error));
                    }
                    jsonElement = new JsonParser().parse(responseBody).getAsJsonObject().get("result");
                    if (jsonElement.isJsonObject()) {
                        callback.onResponse(RpcService.this.gson.fromJson((JsonElement)jsonElement.getAsJsonObject(), cls));
                    }
                } else {
                    throw new IOException("RpcService method " + method + " error code " + response.code());
                }
                callback.onResponse(RpcService.this.gson.fromJson(jsonElement, cls));
            }
        });
    }

    static class RpcResponse<T> {
        long id;
        String jsonrpc;
        T result;
        Error error;

        RpcResponse() {
        }

        class Error {
            public int code;
            public String message;

            Error() {
            }
        }
    }

    static class RequestParams {
        String jsonrpc = "2.0";
        String method;
        List params;
        long id;

        public RequestParams(String method, List params) {
            this.method = method;
            this.params = params;
            this.id = nextId.getAndIncrement();
        }
    }
}

