/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.Utils;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;

public class TransactionBuilder {
    private static final BigInteger MIN_CAPACITY = new BigInteger("6000000000");
    private SystemScriptCell systemSecpCell;
    private List<CellInput> cellInputs = new ArrayList<CellInput>();
    private List<CellOutput> cellOutputs = new ArrayList<CellOutput>();
    private List<String> cellOutputsData = new ArrayList<String>();
    private List<String> witnesses = new ArrayList<String>();
    private Transaction transaction;

    public TransactionBuilder(Api api) {
        try {
            this.systemSecpCell = Utils.getSystemScriptCell(api);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addInput(CellInput input) {
        this.cellInputs.add(input);
    }

    public void addInputs(List<CellInput> inputs) {
        this.cellInputs.addAll(inputs);
    }

    public void addOutput(CellOutput output) {
        this.cellOutputs.add(output);
    }

    public void addOutputs(List<CellOutput> outputs) {
        this.cellOutputs.addAll(outputs);
    }

    public void buildTx() throws IOException {
        int i;
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput output : this.cellOutputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)output.capacity));
        }
        if (needCapacity.compareTo(MIN_CAPACITY) < 0) {
            throw new IOException("Less than min capacity");
        }
        if (this.cellInputs.size() == 0) {
            throw new IOException("Cell inputs could not empty");
        }
        for (i = 0; i < this.cellOutputs.size(); ++i) {
            this.cellOutputsData.add("0x");
        }
        for (i = 0; i < this.cellInputs.size(); ++i) {
            this.witnesses.add("0x");
        }
        this.transaction = new Transaction("0", Collections.singletonList(new CellDep(this.systemSecpCell.outPoint, "dep_group")), Collections.emptyList(), this.cellInputs, this.cellOutputs, this.cellOutputsData, this.witnesses);
    }

    public void signInput(int index, String privateKey) throws IOException {
        if (this.transaction == null) {
            throw new IOException("Transaction could not null");
        }
        if (this.witnesses.size() < this.cellInputs.size()) {
            throw new IOException("Invalid number of witnesses");
        }
        this.witnesses.set(index, this.signWitness(this.witnesses.get(index), privateKey));
    }

    public void sign(String privateKey) {
        for (String witness : this.witnesses) {
            this.witnesses.add(this.signWitness(witness, privateKey));
        }
    }

    private String signWitness(String witness, String privateKey) {
        ECKeyPair ecKeyPair = ECKeyPair.createWithPrivateKey((String)privateKey, (boolean)false);
        Blake2b blake2b = new Blake2b();
        blake2b.update(Numeric.hexStringToByteArray((String)this.transaction.computeHash()));
        blake2b.update(Numeric.hexStringToByteArray((String)witness));
        String message = blake2b.doFinalString();
        String signature = Numeric.toHexString((byte[])Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)message), (ECKeyPair)ecKeyPair).getSignature());
        return signature + Numeric.cleanHexPrefix((String)witness);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

