/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CollectedCells;
import org.nervos.ckb.transaction.Utils;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.utils.Numeric;

public class CellCollector {
    private Api api;

    public CellCollector(Api api) {
        this.api = api;
    }

    public CollectedCells getCellInputs(String lockHash, BigInteger needCapacity, BigInteger fee) throws IOException {
        ArrayList<CellInput> cellInputs = new ArrayList<CellInput>();
        BigInteger inputsCapacity = BigInteger.ZERO;
        ArrayList<Witness> witnesses = new ArrayList<Witness>();
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        BigInteger sumNeedCapacity = needCapacity.add(fee);
        while (fromBlockNumber <= toBlockNumber && inputsCapacity.compareTo(sumNeedCapacity) < 0) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List<CellOutputWithOutPoint> cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputs) {
                    CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                    inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellOutputWithOutPoint.capacity));
                    cellInputs.add(cellInput);
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    break;
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        witnesses.add(new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
        if (inputsCapacity.compareTo(sumNeedCapacity) < 0) {
            throw new IOException("Capacity not enough!");
        }
        return new CollectedCells(cellInputs, inputsCapacity, witnesses);
    }

    public CollectedCells getCellInputs(String lockHash, BigInteger needCapacity) throws IOException {
        return this.getCellInputs(lockHash, needCapacity, BigInteger.ZERO);
    }

    public BigInteger getCapacityWithAddress(String address) throws IOException {
        return this.getCapacityWithAddress(address, CodeHashType.BLAKE160);
    }

    public BigInteger getCapacityWithAddress(String address, CodeHashType codeHashType) throws IOException {
        SystemScriptCell systemScriptCell = codeHashType == CodeHashType.BLAKE160 ? SystemContract.getSystemSecpCell(this.api) : SystemContract.getSystemMultiSigCell(this.api);
        Script lockScript = Utils.generateLockScriptWithAddress(address, systemScriptCell.cellHash, codeHashType);
        return this.getCapacityWithLockHash(lockScript.computeHash());
    }

    public BigInteger getCapacityWithLockHash(String lockHash) throws IOException {
        BigInteger capacity = BigInteger.ZERO;
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        while (fromBlockNumber <= toBlockNumber) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List<CellOutputWithOutPoint> cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint output : cellOutputs) {
                    capacity = capacity.add(Numeric.toBigInt((String)output.capacity));
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        return capacity;
    }
}

