/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CellsWithPrivateKey;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.dynamic.Table;
import org.nervos.ckb.type.fixed.UInt64;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;

public class TransactionBuilder {
    private static final BigInteger MIN_CAPACITY = new BigInteger("6000000000");
    private SystemScriptCell systemSecpCell;
    private SystemScriptCell systemMultiSigCell;
    private List<CellInput> cellInputs = new ArrayList<CellInput>();
    private List<CellsWithPrivateKey> cellsWithPrivateKeys = new ArrayList<CellsWithPrivateKey>();
    private List<CellOutput> cellOutputs = new ArrayList<CellOutput>();
    private List<String> cellOutputsData = new ArrayList<String>();
    private List<String> witnesses = new ArrayList<String>();
    private Transaction transaction;
    private boolean containMultiSig = false;

    public TransactionBuilder(Api api) {
        this(api, false);
    }

    public TransactionBuilder(Api api, boolean containMultiSig) {
        try {
            this.containMultiSig = containMultiSig;
            this.systemSecpCell = SystemContract.getSystemSecpCell(api);
            if (containMultiSig) {
                this.systemMultiSigCell = SystemContract.getSystemMultiSigCell(api);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addInputsWithPrivateKey(CellsWithPrivateKey cellsWithPrivateKey) {
        this.cellsWithPrivateKeys.add(cellsWithPrivateKey);
        this.cellInputs.addAll(cellsWithPrivateKey.inputs);
    }

    public void addInputsWithPrivateKeys(List<CellsWithPrivateKey> cellsWithPrivateKeys) {
        this.cellsWithPrivateKeys.addAll(cellsWithPrivateKeys);
        for (CellsWithPrivateKey cellsWithPrivateKey : cellsWithPrivateKeys) {
            this.cellInputs.addAll(cellsWithPrivateKey.inputs);
        }
    }

    public void addOutput(CellOutput output) {
        this.cellOutputs.add(output);
    }

    public void addOutputs(List<CellOutput> outputs) {
        this.cellOutputs.addAll(outputs);
    }

    private List<String> signWitness(List witnessesWithPrivateKeys, String privateKey) {
        if (witnessesWithPrivateKeys.size() < 1) {
            throw new RuntimeException("Need at least one witness!");
        }
        if (witnessesWithPrivateKeys.get(0).getClass() != Witness.class) {
            throw new RuntimeException("First witness must be of Witness type!");
        }
        String txHash = this.transaction.computeHash();
        Witness emptiedWitness = (Witness)witnessesWithPrivateKeys.get(0);
        emptiedWitness.lock = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        Table witnessTable = Serializer.serializeWitnessArgs(emptiedWitness);
        Blake2b blake2b = new Blake2b();
        blake2b.update(Numeric.hexStringToByteArray((String)txHash));
        blake2b.update(new UInt64(witnessTable.getLength()).toBytes());
        blake2b.update(witnessTable.toBytes());
        for (int i = 1; i < witnessesWithPrivateKeys.size(); ++i) {
            byte[] bytes = witnessesWithPrivateKeys.get(i).getClass() == Witness.class ? Serializer.serializeWitnessArgs((Witness)witnessesWithPrivateKeys.get(i)).toBytes() : Numeric.hexStringToByteArray((String)((String)witnessesWithPrivateKeys.get(i)));
            blake2b.update(new UInt64(bytes.length).toBytes());
            blake2b.update(bytes);
        }
        String message = blake2b.doFinalString();
        ECKeyPair ecKeyPair = ECKeyPair.createWithPrivateKey((String)privateKey, (boolean)false);
        ((Witness)witnessesWithPrivateKeys.get((int)0)).lock = Numeric.toHexString((byte[])Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)message), (ECKeyPair)ecKeyPair).getSignature());
        ArrayList<String> signedWitness = new ArrayList<String>();
        for (Object witness : witnessesWithPrivateKeys) {
            if (witness.getClass() == Witness.class) {
                signedWitness.add(Numeric.toHexString((byte[])Serializer.serializeWitnessArgs((Witness)witness).toBytes()));
                continue;
            }
            signedWitness.add((String)witness);
        }
        return signedWitness;
    }

    public void buildTx() throws IOException {
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput output : this.cellOutputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)output.capacity));
        }
        if (needCapacity.compareTo(MIN_CAPACITY) < 0) {
            throw new IOException("Less than min capacity");
        }
        if (this.cellInputs.size() == 0) {
            throw new IOException("Cell inputs could not empty");
        }
        for (int i = 0; i < this.cellOutputs.size(); ++i) {
            this.cellOutputsData.add("0x");
        }
        ArrayList<CellDep> cellDeps = new ArrayList<CellDep>();
        cellDeps.add(new CellDep(this.systemSecpCell.outPoint, "dep_group"));
        if (this.containMultiSig) {
            cellDeps.add(new CellDep(this.systemMultiSigCell.outPoint, "dep_group"));
        }
        this.transaction = new Transaction("0", cellDeps, Collections.emptyList(), this.cellInputs, this.cellOutputs, this.cellOutputsData, this.witnesses);
        ArrayList<String> signedWitnesses = new ArrayList<String>();
        for (CellsWithPrivateKey cellsWithPrivateKey : this.cellsWithPrivateKeys) {
            ArrayList<Witness> witnessesWithPrivateKeys = new ArrayList<Witness>();
            for (int i = 0; i < cellsWithPrivateKey.inputs.size(); ++i) {
                witnessesWithPrivateKeys.add(new Witness());
            }
            signedWitnesses.addAll(this.signWitness(witnessesWithPrivateKeys, cellsWithPrivateKey.privateKey));
        }
        this.transaction.witnesses = signedWitnesses;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

