/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.io.IOException;
import java.math.BigInteger;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.type.dynamic.Table;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;

public class Calculator {
    private static final int SERIALIZED_TX_OFFSET_BYTE_SIZE = 4;
    private static final int MIN_CONFIRM_BLOCKS = 3;
    private static final BigInteger RADIO = BigInteger.valueOf(1000L);

    public static int calculateSerializedSizeInBlock(Transaction transaction) {
        Table serializedTx = Serializer.serializeTransaction(transaction);
        return serializedTx.getLength() + 4;
    }

    public static BigInteger calculateTransactionFee(BigInteger transactionSize, BigInteger feeRate) {
        BigInteger base = transactionSize.multiply(feeRate);
        BigInteger fee = base.divide(RADIO);
        if (fee.multiply(RADIO).compareTo(base) < 0) {
            return fee.add(BigInteger.ONE);
        }
        return fee;
    }

    public static BigInteger calculateTransactionFee(Api api, Transaction transaction, long expectedConfirmBlocks) throws IOException {
        if (expectedConfirmBlocks < 3L) {
            throw new IOException("Confirm block must not be smaller than 3");
        }
        BigInteger feeRate = Numeric.toBigInt((String)api.estimateFeeRate((String)String.valueOf((long)expectedConfirmBlocks)).feeRate);
        BigInteger txSize = BigInteger.valueOf(Calculator.calculateSerializedSizeInBlock(transaction));
        return Calculator.calculateTransactionFee(txSize, feeRate);
    }
}

