/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.base.Type;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.dynamic.Bytes;
import org.nervos.ckb.type.dynamic.Dynamic;
import org.nervos.ckb.type.dynamic.Option;
import org.nervos.ckb.type.dynamic.Table;
import org.nervos.ckb.type.fixed.Byte1;
import org.nervos.ckb.type.fixed.Byte32;
import org.nervos.ckb.type.fixed.Empty;
import org.nervos.ckb.type.fixed.Fixed;
import org.nervos.ckb.type.fixed.Struct;
import org.nervos.ckb.type.fixed.UInt32;
import org.nervos.ckb.type.fixed.UInt64;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Convert;
import org.nervos.ckb.utils.Strings;

public class Serializer {
    public static Struct serializeOutPoint(OutPoint outPoint) {
        Byte32 txHash = new Byte32(outPoint.txHash);
        UInt32 index = new UInt32(outPoint.index);
        return new Struct(new Type[]{txHash, index});
    }

    public static Table serializeScript(Script script) {
        return new Table(new Type[]{new Byte32(script.codeHash), new Byte1("data".equals(script.hashType) ? "00" : "01"), new Bytes(script.args)});
    }

    public static Struct serializeCellInput(CellInput cellInput) {
        UInt64 sinceUInt64 = new UInt64(cellInput.since);
        Struct outPointStruct = Serializer.serializeOutPoint(cellInput.previousOutput);
        return new Struct(new Type[]{sinceUInt64, outPointStruct});
    }

    public static Table serializeCellOutput(CellOutput cellOutput) {
        return new Table(new Type[]{new UInt64(cellOutput.capacity), Serializer.serializeScript(cellOutput.lock), cellOutput.type != null ? Serializer.serializeScript(cellOutput.type) : new Empty()});
    }

    public static Struct serializeCellDep(CellDep cellDep) {
        Struct outPointStruct = Serializer.serializeOutPoint(cellDep.outPoint);
        Byte1 depTypeBytes = "code".equals(cellDep.depType) ? new Byte1("0") : new Byte1("1");
        return new Struct(new Type[]{outPointStruct, depTypeBytes});
    }

    public static Fixed<Struct> serializeCellDeps(List<CellDep> cellDeps) {
        ArrayList<Struct> cellDepList = new ArrayList<Struct>();
        for (CellDep cellDep : cellDeps) {
            cellDepList.add(Serializer.serializeCellDep(cellDep));
        }
        return new Fixed(cellDepList);
    }

    public static Fixed<Struct> serializeCellInputs(List<CellInput> cellInputs) {
        ArrayList<Struct> cellInputList = new ArrayList<Struct>();
        for (CellInput cellInput : cellInputs) {
            cellInputList.add(Serializer.serializeCellInput(cellInput));
        }
        return new Fixed(cellInputList);
    }

    public static Dynamic<Table> serializeCellOutputs(List<CellOutput> cellOutputs) {
        ArrayList<Table> cellOutputList = new ArrayList<Table>();
        for (CellOutput cellOutput : cellOutputs) {
            cellOutputList.add(Serializer.serializeCellOutput(cellOutput));
        }
        return new Dynamic(cellOutputList);
    }

    public static Dynamic<Bytes> serializeBytes(List<String> bytes) {
        ArrayList<Bytes> bytesList = new ArrayList<Bytes>();
        for (String data : bytes) {
            bytesList.add(new Bytes(data));
        }
        return new Dynamic(bytesList);
    }

    public static Fixed<Byte32> serializeByte32(List<String> bytes) {
        ArrayList<Byte32> byte32List = new ArrayList<Byte32>();
        for (String data : bytes) {
            byte32List.add(new Byte32(data));
        }
        return new Fixed(byte32List);
    }

    public static Table serializeWitnessArgs(Witness witness) {
        return new Table(new Type[]{new Option((Type)(Strings.isEmpty((String)witness.lock) ? new Empty() : new Bytes(witness.lock))), new Option((Type)(Strings.isEmpty((String)witness.inputType) ? new Empty() : new Bytes(witness.inputType))), new Option((Type)(Strings.isEmpty((String)witness.outputType) ? new Empty() : new Bytes(witness.outputType)))});
    }

    public static Table serializeRawTransaction(Transaction transaction) {
        Transaction tx = Convert.parseTransaction(transaction);
        UInt32 versionUInt32 = new UInt32(tx.version);
        Fixed<Struct> cellDepFixed = Serializer.serializeCellDeps(tx.cellDeps);
        Fixed<Byte32> headerDepFixed = Serializer.serializeByte32(tx.headerDeps);
        Fixed<Struct> inputsFixed = Serializer.serializeCellInputs(tx.inputs);
        Dynamic<Table> outputsVec = Serializer.serializeCellOutputs(tx.outputs);
        Dynamic<Bytes> dataVec = Serializer.serializeBytes(tx.outputsData);
        return new Table(new Type[]{versionUInt32, cellDepFixed, headerDepFixed, inputsFixed, outputsVec, dataVec});
    }

    public static Table serializeTransaction(Transaction transaction) {
        Table rawTransactionTable = Serializer.serializeRawTransaction(transaction);
        Dynamic<Bytes> witnessesVec = Serializer.serializeBytes(transaction.witnesses);
        return new Table(new Type[]{rawTransactionTable, witnessesVec});
    }
}

