/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.math.BigInteger;
import org.nervos.ckb.utils.Numeric;

public class EpochUtils {
    public static EpochInfo parse(String hexEpoch) {
        long epochLong = Numeric.toBigInt((String)hexEpoch).longValue();
        long length = epochLong >> 40 & 0xFFFFL;
        long index = epochLong >> 24 & 0xFFFFL;
        long number = epochLong & 0xFFFFFFL;
        return new EpochInfo(length, index, number);
    }

    public static String generate(long length, long index, long number) {
        BigInteger epoch = BigInteger.valueOf((length << 40) + (index << 24) + number);
        return Numeric.toHexStringWithPrefix((BigInteger)epoch);
    }

    public static String generateSince(long length, long index, long number) {
        BigInteger bigInteger = Numeric.toBigInt((String)"0x20").shiftLeft(56);
        BigInteger epoch = BigInteger.valueOf((length << 40) + (index << 24) + number);
        return Numeric.toHexStringWithPrefix((BigInteger)bigInteger.add(epoch));
    }

    public static class EpochInfo {
        public long length;
        public long index;
        public long number;

        public EpochInfo(long length, long index, long number) {
            this.length = length;
            this.index = index;
            this.number = number;
        }
    }
}

