/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils.address;

import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.List;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.exceptions.AddressFormatException;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Bech32;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.AddressBaseOperator;

public class AddressGenerator
extends AddressBaseOperator {
    private static final List<String> codeHashes = Arrays.asList("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8", "d369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354", "3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356");

    public static String generate(Network network, Script script) {
        String codeHash = Numeric.cleanHexPrefix((String)script.codeHash);
        String args = Numeric.cleanHexPrefix((String)script.args);
        if ("type".equals(script.hashType) && args.length() >= 40 && args.length() <= 44 && codeHashes.contains(codeHash)) {
            return AddressGenerator.generateShortAddress(network, codeHash, args);
        }
        return AddressGenerator.generateFullAddress(network, script);
    }

    private static String generateShortAddress(Network network, String codeHash, String args) {
        String codeHashIndex = "";
        if ("d369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354".equals(codeHash) || "3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356".equals(codeHash)) {
            codeHashIndex = "02";
        } else if (args.length() == 40) {
            if ("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8".equals(codeHash)) {
                codeHashIndex = "00";
            } else if ("5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8".equals(codeHash)) {
                codeHashIndex = "01";
            }
        }
        if (codeHashIndex.isEmpty()) {
            throw new AddressFormatException("Code hash index of address format error");
        }
        String payload = "01" + codeHashIndex + args;
        byte[] data = Numeric.hexStringToByteArray((String)payload);
        return Bech32.encode((String)AddressGenerator.prefix(network), (byte[])AddressGenerator.convertBits(Bytes.asList((byte[])data), 8, 5, true));
    }

    public static String generateFullAddress(Network network, Script script) {
        String type = "type".equals(script.hashType) ? "04" : "02";
        String payload = type + Numeric.cleanHexPrefix((String)script.codeHash) + Numeric.cleanHexPrefix((String)script.args);
        byte[] data = Numeric.hexStringToByteArray((String)payload);
        return Bech32.encode((String)AddressGenerator.prefix(network), (byte[])AddressGenerator.convertBits(Bytes.asList((byte[])data), 8, 5, true));
    }

    private static String prefix(Network network) {
        return network == Network.MAINNET ? "ckb" : "ckt";
    }
}

