/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.exceptions.AddressFormatException;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class AddressParserTest {
    @Test
    void testSingleSigShortTestnetAddressParse() {
        String address = "ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83";
        Script singleSigShortScript = new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.TESTNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)singleSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)singleSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)singleSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testSingleSigShortMainnetAddressParse() {
        String address = "ckb1qyqrdsefa43s6m882pcj53m4gdnj4k440axqdt9rtd";
        Script singleSigShortScript = new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.MAINNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)singleSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)singleSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)singleSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testMultiSigShortTestnetAddressParse() {
        String address = "ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq";
        Script multiSigShortScript = new Script("0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8", "0xf04cec84bc37f683613bed2f242c9aa1b678e9fe", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.TESTNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)multiSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)multiSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)multiSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testMultiSigShortMainnetAddressParse() {
        String address = "ckb1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lq2sg8su";
        Script multiSigShortScript = new Script("0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8", "0xf04cec84bc37f683613bed2f242c9aa1b678e9fe", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.MAINNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)multiSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)multiSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)multiSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testACPShortTestnetAddressParse() {
        String address = "ckt1qypgzvf2uphwkpgykum7d0862wtmuddf9r0qnzefn9";
        Script multiSigShortScript = new Script("0x3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356", "0x81312ae06eeb0504b737e6bcfa5397be35a928de", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.TESTNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)multiSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)multiSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)multiSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testACPShortMainnetAddressParse() {
        String address = "ckb1qypgzvf2uphwkpgykum7d0862wtmuddf9r0qw88kle";
        Script multiSigShortScript = new Script("0xd369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354", "0x81312ae06eeb0504b737e6bcfa5397be35a928de", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.MAINNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)multiSigShortScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)multiSigShortScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)multiSigShortScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testTypeFullTestnetAddressParse() {
        String address = "ckt1qsvf96jqmq4483ncl7yrzfzshwchu9jd0glq4yy5r2jcsw04d7xlydkr98kkxrtvuag8z2j8w4pkw2k6k4l5c02auef";
        Script typeFullScript = new Script("0x1892ea40d82b53c678ff88312450bbb17e164d7a3e0a90941aa58839f56f8df2", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.TESTNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)typeFullScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)typeFullScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)typeFullScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testTypeFullMainnetAddressParse() {
        String address = "ckb1qsvf96jqmq4483ncl7yrzfzshwchu9jd0glq4yy5r2jcsw04d7xlydkr98kkxrtvuag8z2j8w4pkw2k6k4l5czfy37k";
        Script typeFullScript = new Script("0x1892ea40d82b53c678ff88312450bbb17e164d7a3e0a90941aa58839f56f8df2", "0x36c329ed630d6ce750712a477543672adab57f4c", "type");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.MAINNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)typeFullScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)typeFullScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)typeFullScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testDataFullTestnetAddressParse() {
        String address = "ckt1q2n9dutjk669cfznq7httfar0gtk7qp0du3wjfvzck9l0w3k9eqhvdkr98kkxrtvuag8z2j8w4pkw2k6k4l5czshhac";
        Script dataFullScript = new Script("0xa656f172b6b45c245307aeb5a7a37a176f002f6f22e92582c58bf7ba362e4176", "0x36c329ed630d6ce750712a477543672adab57f4c", "data");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.TESTNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)dataFullScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)dataFullScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)dataFullScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testDataFullMainnetAddressParse() {
        String address = "ckb1q2n9dutjk669cfznq7httfar0gtk7qp0du3wjfvzck9l0w3k9eqhvdkr98kkxrtvuag8z2j8w4pkw2k6k4l5c0nw668";
        Script dataFullScript = new Script("0xa656f172b6b45c245307aeb5a7a37a176f002f6f22e92582c58bf7ba362e4176", "0x36c329ed630d6ce750712a477543672adab57f4c", "data");
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        Assertions.assertEquals((Object)Network.MAINNET, (Object)addressParseResult.network);
        Assertions.assertEquals((Object)dataFullScript.args, (Object)addressParseResult.script.args);
        Assertions.assertEquals((Object)dataFullScript.codeHash, (Object)addressParseResult.script.codeHash);
        Assertions.assertEquals((Object)dataFullScript.hashType, (Object)addressParseResult.script.hashType);
    }

    @Test
    void testParseAddressNetworkException() {
        final String address = "ckn1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83";
        AddressFormatException exception = (AddressFormatException)Assertions.assertThrows(AddressFormatException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                AddressParser.parseNetwork((String)address);
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Address prefix should be ckb or ckt"));
    }

    @Test
    void testFullAddressTypeException() {
        final String address = "ckt1qwn9dutjk669cfznq7httfar0gtk7qp0du3wjfvzck9l0w3k9eqhvdkr98kkxrtvuag8z2j8w4pkw2k6k4l5ctv25r2";
        AddressFormatException exception = (AddressFormatException)Assertions.assertThrows(AddressFormatException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                AddressParser.parse((String)address);
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Full address type must be 02 or 04"));
    }

    @Test
    void testShortAddressTypeException() {
        final String address = "ckt1qyzndsefa43s6m882pcj53m4gdnj4k440axqcth0hp";
        AddressFormatException exception = (AddressFormatException)Assertions.assertThrows(AddressFormatException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                AddressParser.parse((String)address);
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Short address code hash index must be 00, 01 or 02"));
    }

    @Test
    void testShortAddressArgsLengthException() {
        final String address = "ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqqm65l9j";
        AddressFormatException exception = (AddressFormatException)Assertions.assertThrows(AddressFormatException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                AddressParser.parse((String)address);
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Short address args byte length must be equal to 20"));
    }

    @Test
    void testAddressPayloadLengthException() {
        final String address = "ckt1qsvf96jqmq4483ncl7yrzfzshwchu9jd0glq4yy5r2jcsw04r0l5xl";
        AddressFormatException exception = (AddressFormatException)Assertions.assertThrows(AddressFormatException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                AddressParser.parse((String)address);
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Invalid full address payload length"));
    }
}

