/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.nervos.ckb.service.RpcCallback;
import org.nervos.ckb.service.RpcResponse;
import org.nervos.ckb.utils.Numeric;

public class RpcService {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private static AtomicLong nextId = new AtomicLong(0L);
    private OkHttpClient client;
    private String url;
    private Gson gson;

    public RpcService(String rpcUrl, boolean isDebug) {
        this.url = rpcUrl;
        if (isDebug) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.level(HttpLoggingInterceptor.Level.BODY);
            this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)logging).retryOnConnectionFailure(true).build();
        } else {
            this.client = new OkHttpClient.Builder().connectTimeout(180L, TimeUnit.SECONDS).readTimeout(180L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
        }
        this.gson = new Gson();
    }

    public <T> T post(@NotNull String method, List params, Type cls) throws IOException {
        return this.post(method, params, cls, this.gson);
    }

    public <T> T post(@NotNull String method, List params, Type cls, Gson gson) throws IOException {
        RequestParams requestParams = new RequestParams(method, params);
        RequestBody body = RequestBody.create((String)gson.toJson((Object)requestParams), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(this.url).post(body).build();
        Response response = this.client.newCall(request).execute();
        String responseBody = Objects.requireNonNull(response.body()).string();
        if (response.isSuccessful()) {
            RpcResponse rpcResponse = (RpcResponse)gson.fromJson(responseBody, new TypeToken<RpcResponse>(){}.getType());
            if (rpcResponse.error != null) {
                throw new IOException("RpcService method " + method + " error " + gson.toJson((Object)rpcResponse.error));
            }
            JsonElement jsonElement = new JsonParser().parse(responseBody).getAsJsonObject().get("result");
            if (jsonElement.isJsonObject()) {
                return (T)gson.fromJson((JsonElement)jsonElement.getAsJsonObject(), cls);
            }
            return (T)gson.fromJson(jsonElement, cls);
        }
        throw new IOException("RpcService method " + method + " error code " + response.code());
    }

    public <T> void postAsync(final @NotNull String method, List params, final @NotNull Type cls, final @NotNull RpcCallback<T> callback) {
        RequestParams requestParams = new RequestParams(method, params);
        RequestBody body = RequestBody.create((String)this.gson.toJson((Object)requestParams), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(this.url).post(body).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                callback.onFailure(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                JsonElement jsonElement;
                String responseBody = Objects.requireNonNull(response.body()).string();
                if (response.isSuccessful()) {
                    RpcResponse rpcResponse = (RpcResponse)RpcService.this.gson.fromJson(responseBody, new TypeToken<RpcResponse<T>>(){}.getType());
                    if (rpcResponse.error != null) {
                        throw new IOException("RpcService method " + method + " error " + RpcService.this.gson.toJson((Object)rpcResponse.error));
                    }
                    jsonElement = new JsonParser().parse(responseBody).getAsJsonObject().get("result");
                    if (jsonElement.isJsonObject()) {
                        callback.onResponse(RpcService.this.gson.fromJson((JsonElement)jsonElement.getAsJsonObject(), cls));
                    }
                } else {
                    throw new IOException("RpcService method " + method + " error code " + response.code());
                }
                callback.onResponse(RpcService.this.gson.fromJson(jsonElement, cls));
            }
        });
    }

    public List<RpcResponse> batchPost(List<List> requests) throws IOException {
        List request2;
        ArrayList<RequestParams> paramsList = new ArrayList<RequestParams>();
        for (List request2 : requests) {
            if (request2.size() == 0 || !(request2.get(0) instanceof String)) {
                throw new IOException("RPC method name must be a non-null string");
            }
            for (int i = 1; i < request2.size(); ++i) {
                if (!Numeric.isIntegerValue((String)request2.get(i).toString())) continue;
                request2.set(i, Numeric.toHexString((String)request2.get(i).toString()));
            }
            paramsList.add(new RequestParams(request2.get(0).toString(), request2.subList(1, request2.size())));
        }
        RequestBody body = RequestBody.create((String)this.gson.toJson(paramsList), (MediaType)JSON_MEDIA_TYPE);
        request2 = new Request.Builder().url(this.url).post(body).build();
        Response response = this.client.newCall((Request)request2).execute();
        String responseBody = Objects.requireNonNull(response.body()).string();
        if (response.isSuccessful()) {
            return (List)this.gson.fromJson(responseBody, new TypeToken<List<RpcResponse>>(){}.getType());
        }
        throw new IOException("RpcService error code " + response.code());
    }

    static class RequestParams {
        String jsonrpc = "2.0";
        String method;
        List params;
        long id;

        public RequestParams(String method, List params) {
            this.method = method;
            this.params = params;
            this.id = nextId.getAndIncrement();
        }
    }
}

