/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.util.ArrayList;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;

public class Convert {
    public static OutPoint parseOutPoint(OutPoint outPoint) {
        return new OutPoint(outPoint.txHash, Numeric.toHexString((String)outPoint.index));
    }

    public static Transaction parseTransaction(Transaction transaction) {
        ArrayList<CellDep> cellDeps = new ArrayList<CellDep>();
        for (CellDep cellDep : transaction.cellDeps) {
            cellDeps.add(new CellDep(new OutPoint(cellDep.outPoint.txHash, Numeric.toHexString((String)cellDep.outPoint.index)), cellDep.depType));
        }
        ArrayList<CellInput> inputs = new ArrayList<CellInput>();
        for (CellInput cellInput : transaction.inputs) {
            inputs.add(new CellInput(new OutPoint(cellInput.previousOutput.txHash, Numeric.toHexString((String)cellInput.previousOutput.index)), Numeric.toHexString((String)cellInput.since)));
        }
        ArrayList<CellOutput> arrayList = new ArrayList<CellOutput>();
        for (CellOutput cellOutput : transaction.outputs) {
            arrayList.add(new CellOutput(Numeric.toHexString((String)cellOutput.capacity), cellOutput.lock, cellOutput.type));
        }
        return new Transaction(Numeric.toHexString((String)transaction.version), cellDeps, transaction.headerDeps, inputs, arrayList, transaction.outputsData, transaction.witnesses);
    }
}

