/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils.address;

import com.google.common.primitives.Bytes;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.exceptions.AddressFormatException;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Bech32;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.address.AddressBaseOperator;
import org.nervos.ckb.utils.address.AddressParseResult;

public class AddressParser
extends AddressBaseOperator {
    public static AddressParseResult parse(String address) throws AddressFormatException {
        Bech32.Bech32Data parsed = Bech32.decode((String)address);
        byte[] data = AddressParser.convertBits(Bytes.asList((byte[])parsed.data), 5, 8, false);
        String payload = Numeric.toHexStringNoPrefix((byte[])data);
        if (payload == null) {
            throw new AddressFormatException("Address bech32 decode fail");
        }
        String type = payload.substring(0, 2);
        Network network = AddressParser.parseNetwork(address);
        if ("01".equals(type)) {
            if (parsed.encoding != Bech32.Encoding.BECH32) {
                throw new AddressFormatException("payload header 0x01 should have encoding BECH32");
            }
            String codeHashIndex = payload.substring(2, 4);
            String args = Numeric.prependHexPrefix((String)payload.substring(4));
            if (!codeHashIndex.equals("02") && Numeric.cleanHexPrefix((String)args).length() / 2 != 20) {
                throw new AddressFormatException("Short address args byte length must be equal to 20");
            }
            switch (codeHashIndex) {
                case "00": {
                    if (data.length != 22) {
                        throw new AddressFormatException("payload bytes length of secp256k1-sighash-all short address should be 22");
                    }
                    return new AddressParseResult(network, new Script(Numeric.prependHexPrefix((String)"9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8"), args, "type"), AddressParseResult.Type.SHORT);
                }
                case "01": {
                    if (data.length != 22) {
                        throw new AddressFormatException("payload bytes length of secp256k1-multisig-all short address should be 22");
                    }
                    return new AddressParseResult(network, new Script(Numeric.prependHexPrefix((String)"5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8"), args, "type"), AddressParseResult.Type.SHORT);
                }
                case "02": {
                    if (data.length < 22 || data.length > 24) {
                        throw new AddressFormatException("payload bytes length of anyone-can-pay short address should be between 22 and 24");
                    }
                    String codeHash = Numeric.prependHexPrefix((String)(network == Network.MAINNET ? "d369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354" : "3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356"));
                    return new AddressParseResult(network, new Script(codeHash, args, "type"), AddressParseResult.Type.SHORT);
                }
            }
            throw new AddressFormatException("Short address code hash index must be 00, 01 or 02");
        }
        if (payload.length() < 66) {
            throw new AddressFormatException("Invalid full address payload length");
        }
        if ("02".equals(type)) {
            if (parsed.encoding != Bech32.Encoding.BECH32) {
                throw new AddressFormatException("payload header 0x02 should have encoding BECH32");
            }
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String args = Numeric.prependHexPrefix((String)payload.substring(66));
            return new AddressParseResult(network, new Script(codeHash, args, "data"), AddressParseResult.Type.FULL);
        }
        if ("04".equals(type)) {
            if (parsed.encoding != Bech32.Encoding.BECH32) {
                throw new AddressFormatException("payload header 0x04 should have encoding BECH32");
            }
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String args = Numeric.prependHexPrefix((String)payload.substring(66));
            return new AddressParseResult(network, new Script(codeHash, args, "type"), AddressParseResult.Type.FULL);
        }
        if ("00".equals(type)) {
            if (parsed.encoding != Bech32.Encoding.BECH32M) {
                throw new AddressFormatException("payload header 0x00 should have encoding BECH32M");
            }
            String codeHash = Numeric.prependHexPrefix((String)payload.substring(2, 66));
            String hashType = Serializer.deserializeHashType(payload.substring(66, 68));
            String args = Numeric.prependHexPrefix((String)payload.substring(68));
            return new AddressParseResult(network, new Script(codeHash, args, hashType), AddressParseResult.Type.FULL);
        }
        throw new AddressFormatException("Full address type must be 02 or 04");
    }

    public static Network parseNetwork(String address) {
        if (address.startsWith("ckb")) {
            return Network.MAINNET;
        }
        if (address.startsWith("ckt")) {
            return Network.TESTNET;
        }
        throw new AddressFormatException("Address prefix should be ckb or ckt");
    }
}

