/*
 * Decompiled with CFR 0.152.
 */
package sign;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.sign.signer.Secp256k1Blake160SighashAllSigner;
import org.nervos.ckb.utils.Numeric;
import sign.SignerChecker;

public class Secp256k1Blake160SighashAllSignerTest {
    @Test
    void testIsMatched() {
        Secp256k1Blake160SighashAllSigner signer = Secp256k1Blake160SighashAllSigner.getInstance();
        Assertions.assertTrue((boolean)signer.isMatched(ECKeyPair.create((String)"9d8ca87d75d150692211fa62b0d30de4d1ee6c530d5678b40b8cedacf0750d0f"), Numeric.hexStringToByteArray((String)"0xaf0b41c627807fbddcee75afa174d5a7e5135ebd")));
        Assertions.assertFalse((boolean)signer.isMatched(ECKeyPair.create((String)"0x9d8ca87d75d150692211fa62b0d30de4d1ee6c530d5678b40b8cedacf0750d0f"), Numeric.hexStringToByteArray((String)"0x0450340178ae277261a838c89f9ccb76a190ed4b")));
        Assertions.assertFalse((boolean)signer.isMatched(null, Numeric.hexStringToByteArray((String)"0xaf0b41c627807fbddcee75afa174d5a7e5135ebd")));
        Assertions.assertFalse((boolean)signer.isMatched(ECKeyPair.create((String)"9d8ca87d75d150692211fa62b0d30de4d1ee6c530d5678b40b8cedacf0750d0f"), null));
    }

    @Test
    void testSecp256k1Blake160OneInput() {
        SignerChecker.signAndCheck("secp256k1_blake16_sighash_all_one_input");
    }

    @Test
    void testSecp256k1Blake160OneGroup() {
        SignerChecker.signAndCheck("secp256k1_blake16_sighash_all_one_group");
    }

    @Test
    void testSecp256k1Blake160TwoGroups() {
        SignerChecker.signAndCheck("secp256k1_blake16_sighash_all_two_groups");
    }

    @Test
    void testSecp256k1Blake160ExtraWitness() {
        SignerChecker.signAndCheck("secp256k1_blake16_sighash_all_extra_witness");
    }
}

