/*
 * Decompiled with CFR 0.152.
 */
package sign;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.nervos.ckb.Network;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.service.GsonFactory;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.sign.signer.Secp256k1Blake160MultisigAllSigner;
import org.nervos.ckb.utils.Numeric;

public class SignerChecker {
    @SerializedName(value="raw_transaction")
    private TransactionWithScriptGroups transaction;
    private List<String> expectedWitnesses;
    private Set<Context> contexts;

    private SignerChecker() {
    }

    private static Gson getGson() {
        JsonDeserializer typeAdapter = (json, typeOfT, context) -> {
            JsonObject obj = json.getAsJsonObject();
            ECKeyPair keyPair = ECKeyPair.create((String)obj.get("private_key").getAsString());
            Context c = new Context(keyPair);
            if (obj.get("multisig_script") != null) {
                JsonObject obj2 = obj.get("multisig_script").getAsJsonObject();
                int threshold = obj2.get("threshold").getAsInt();
                int firstN = obj2.get("first_n").getAsInt();
                ArrayList<byte[]> keyHashes = new ArrayList<byte[]>();
                for (JsonElement e : obj2.get("key_hashes").getAsJsonArray()) {
                    keyHashes.add(Numeric.hexStringToByteArray((String)e.getAsString()));
                }
                Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript = new Secp256k1Blake160MultisigAllSigner.MultisigScript(firstN, threshold, keyHashes);
                c.setPayload((Object)multisigScript);
            }
            return c;
        };
        Gson gson = GsonFactory.create().newBuilder().registerTypeAdapter(Context.class, (Object)typeAdapter).create();
        return gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SignerChecker fromFile(String fileName) {
        try (Reader reader = SignerChecker.readTransactionJsonFile(fileName);){
            Gson gson = SignerChecker.getGson();
            SignerChecker signerChecker = (SignerChecker)gson.fromJson(reader, SignerChecker.class);
            return signerChecker;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Reader readTransactionJsonFile(String fileName) throws IOException {
        String filePath = "src/test/resources/transaction/" + fileName + ".json";
        return Files.newBufferedReader(Paths.get(filePath, new String[0]));
    }

    public static void signAndCheck(String fileName) {
        SignerChecker checker = SignerChecker.fromFile(fileName);
        checker.signAndCheck();
    }

    private void signAndCheck() {
        TransactionSigner txSigner = TransactionSigner.getInstance((Network)Network.TESTNET);
        Set<Integer> signedGroupsIndices = this.signTransaction(txSigner);
        Assertions.assertEquals((int)this.transaction.getScriptGroups().size(), (int)signedGroupsIndices.size());
        for (int i = 0; i < this.transaction.getScriptGroups().size(); ++i) {
            Assertions.assertEquals((Object)true, (Object)signedGroupsIndices.contains(i));
        }
        this.check();
    }

    private Set<Integer> signTransaction(TransactionSigner transactionSigner) {
        return transactionSigner.signTransaction(this.transaction, this.contexts);
    }

    private void check() {
        List witnesses = this.transaction.getTxView().witnesses;
        Assertions.assertNotEquals((int)0, (int)witnesses.size());
        Assertions.assertEquals((int)this.expectedWitnesses.size(), (int)witnesses.size());
        for (int i = 0; i < this.expectedWitnesses.size(); ++i) {
            Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)this.expectedWitnesses.get(i)), (byte[])((byte[])witnesses.get(i)));
        }
    }
}

