/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.Network;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;
import org.nervos.ckb.utils.address.AddressFormatException;

public class AddressTest {
    private Script secp256k1Blake160Script = new Script(Numeric.hexStringToByteArray((String)"0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8"), Numeric.hexStringToByteArray((String)"0xb39bbc0b3673c7d36450bc14cfcdad2d559c6c64"), Script.HashType.TYPE);
    private Script multiSignScript = new Script(Numeric.hexStringToByteArray((String)"0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8"), Numeric.hexStringToByteArray((String)"0x4fb2be2e5d0c1a3b8694f832350a33c1685d477a"), Script.HashType.TYPE);
    private Script acpScript = new Script(Numeric.hexStringToByteArray((String)"0xd369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354"), Numeric.hexStringToByteArray((String)"bd07d9f32bce34d27152a6a0391d324f79aab854"), Script.HashType.TYPE);
    private Script script4 = new Script(Numeric.hexStringToByteArray((String)"9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8"), Numeric.hexStringToByteArray((String)"b39bbc0b3673c7d36450bc14cfcdad2d559c6c64"), Script.HashType.DATA);

    @Test
    public void testEncode() {
        Address address = new Address(this.secp256k1Blake160Script, Network.MAINNET);
        Assertions.assertEquals((Object)"ckb1qyqt8xaupvm8837nv3gtc9x0ekkj64vud3jqfwyw5v", (Object)address.encodeShort());
        Assertions.assertEquals((Object)"ckb1qjda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxgj53qks", (Object)address.encodeFullBech32());
        Assertions.assertEquals((Object)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdnnw7qkdnnclfkg59uzn8umtfd2kwxceqxwquc4", (Object)address.encodeFullBech32m());
        Assertions.assertEquals((Object)"ckb1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqklhtgg", (Object)new Address(this.multiSignScript, Network.MAINNET).encodeShort());
        Assertions.assertEquals((Object)"ckt1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqt6f5y5", (Object)new Address(this.multiSignScript, Network.TESTNET).encodeShort());
        Assertions.assertEquals((Object)"ckb1qypt6p7e7v4uudxjw9f2dgper5ey77d2hp2qxz4u4u", (Object)new Address(this.acpScript, Network.MAINNET).encodeShort());
        Assertions.assertEquals((Object)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqvguktl", (Object)new Address(this.script4, Network.MAINNET).encodeFullBech32m());
        Assertions.assertEquals((Object)"ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqz6hep8", (Object)new Address(this.script4, Network.TESTNET).encodeFullBech32m());
    }

    @Test
    public void testDecode() {
        Address expected = new Address(this.secp256k1Blake160Script, Network.MAINNET);
        Address actual = Address.decode((String)"ckb1qyqt8xaupvm8837nv3gtc9x0ekkj64vud3jqfwyw5v");
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = Address.decode((String)"ckb1qjda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxgj53qks");
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdnnw7qkdnnclfkg59uzn8umtfd2kwxceqxwquc4");
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = Address.decode((String)"ckb1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqklhtgg");
        Assertions.assertEquals((Object)new Address(this.multiSignScript, Network.MAINNET), (Object)actual);
        actual = Address.decode((String)"ckt1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqt6f5y5");
        Assertions.assertEquals((Object)new Address(this.multiSignScript, Network.TESTNET), (Object)actual);
        actual = Address.decode((String)"ckb1qypt6p7e7v4uudxjw9f2dgper5ey77d2hp2qxz4u4u");
        Assertions.assertEquals((Object)new Address(this.acpScript, Network.MAINNET), (Object)actual);
        actual = Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqvguktl");
        Assertions.assertEquals((Object)new Address(this.script4, Network.MAINNET), (Object)actual);
        actual = Address.decode((String)"ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqz6hep8");
        Assertions.assertEquals((Object)new Address(this.script4, Network.TESTNET), (Object)actual);
    }

    @Test
    void testInvalidDecode() {
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyqylv479ewscx3ms620sv34pgeuz6zagaaqh0knz7"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyqylv479ewscx3ms620sv34pgeuz6zagaarxdzvx03"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyg5lv479ewscx3ms620sv34pgeuz6zagaaqajch0c"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1q2da0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsnajhch96rq68wrqn2tmhm"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq20k2lzuhgvrgacv4tmr88"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqz0k2lzuhgvrgacvhcym08"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqj0k2lzuhgvrgacvnhnzl8"));
    }
}

