/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign;

import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;
import org.nervos.ckb.type.Transaction;

public class TransactionWithScriptGroups {
    public Transaction txView;
    public List<ScriptGroup> scriptGroups;

    public Transaction getTxView() {
        return this.txView;
    }

    public void setTxView(Transaction txView) {
        this.txView = txView;
    }

    public List<ScriptGroup> getScriptGroups() {
        return this.scriptGroups;
    }

    public void setScriptGroups(List<ScriptGroup> scriptGroups) {
        this.scriptGroups = scriptGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Transaction txView;
        private List<ScriptGroup> scriptGroups = new ArrayList<ScriptGroup>();

        private Builder() {
        }

        public Builder setTxView(Transaction txView) {
            this.txView = txView;
            return this;
        }

        public Builder setScriptGroups(List<ScriptGroup> scriptGroups) {
            this.scriptGroups = scriptGroups;
            return this;
        }

        public Builder addScriptGroup(ScriptGroup scriptGroup) {
            this.scriptGroups.add(scriptGroup);
            return this;
        }

        public Builder addLockScriptGroup(Script script, int ... inputIndices) {
            ScriptGroup scriptGroup = ScriptGroup.builder().setGroupType(ScriptType.LOCK).setScript(script).addInputIndices(inputIndices).build();
            return this.addScriptGroup(scriptGroup);
        }

        public Builder addLockScriptGroup(byte[] codeHash, byte[] args, int ... inputIndices) {
            Script script = new Script(codeHash, args, Script.HashType.TYPE);
            return this.addLockScriptGroup(script, inputIndices);
        }

        public TransactionWithScriptGroups build() {
            TransactionWithScriptGroups transactionWithScriptGroups = new TransactionWithScriptGroups();
            transactionWithScriptGroups.setTxView(this.txView);
            transactionWithScriptGroups.setScriptGroups(this.scriptGroups);
            return transactionWithScriptGroups;
        }
    }
}

