/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import java.util.Arrays;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.utils.MoleculeConverter;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Utils;

public class Script {
    public static final byte[] SECP256_BLAKE160_SIGNHASH_ALL_CODE_HASH = Numeric.hexStringToByteArray((String)"0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8");
    public static final byte[] SECP256_BLAKE160_MULTISIG_ALL_CODE_HASH = Numeric.hexStringToByteArray((String)"0x5c5069eb0857efc65e1bca0c07df34c31663b3622fd3876c876320fc9634e2a8");
    public static final byte[] ANY_CAN_PAY_CODE_HASH_MAINNET = Numeric.hexStringToByteArray((String)"0xd369597ff47f29fbc0d47d2e3775370d1250b85140c670e4718af712983a2354");
    public static final byte[] ANY_CAN_PAY_CODE_HASH_TESTNET = Numeric.hexStringToByteArray((String)"0x3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356");
    public static final byte[] CHEQUE_CODE_HASH_MAINNET = Numeric.hexStringToByteArray((String)"0xe4d4ecc6e5f9a059bf2f7a82cca292083aebc0c421566a52484fe2ec51a9fb0c");
    public static final byte[] CHEQUE_CODE_HASH_TESTNET = Numeric.hexStringToByteArray((String)"0x60d5f39efce409c587cb9ea359cefdead650ca128f0bd9cb3855348f98c70d5b");
    public static final byte[] PW_LOCK_CODE_HASH_MAINNET = Numeric.hexStringToByteArray((String)"0xbf43c3602455798c1a61a596e0d95278864c552fafe231c063b3fabf97a8febc");
    public static final byte[] PW_LOCK_CODE_HASH_TESTNET = Numeric.hexStringToByteArray((String)"0x58c5f491aba6d61678b7cf7edf4910b1f5e00ec0cde2f42e0abb4fd9aff25a63");
    public static final byte[] SUDT_CODE_HASH_MAINNET = Numeric.hexStringToByteArray((String)"0x5e7a36a77e68eecc013dfa2fe6a23f3b6c344b04005808694ae6dd45eea4cfd5");
    public static final byte[] SUDT_CODE_HASH_TESTNET = Numeric.hexStringToByteArray((String)"0xc5e5dcf215925f7ef4dfaf5f4b4f105bc321c02776d6e7d52a1db3fcd9d011a4");
    public static final byte[] DAO_CODE_HASH = Numeric.hexStringToByteArray((String)"0x82d76d1b75fe2fd9a27dfbaa65a039221a380d76c926f378d3f81cf3e7e13f2e");
    public byte[] codeHash;
    public byte[] args;
    public HashType hashType;

    public Script() {
    }

    public Script(byte[] codeHash, byte[] args) {
        this(codeHash, args, HashType.DATA);
    }

    public Script(byte[] codeHash, byte[] args, HashType hashType) {
        this.codeHash = codeHash;
        this.args = args;
        this.hashType = hashType;
    }

    public byte[] computeHash() {
        Blake2b blake2b = new Blake2b();
        blake2b.update(this.pack().toByteArray());
        return blake2b.doFinal();
    }

    public long occupiedCapacity() {
        int byteSize = 1;
        if (this.codeHash != null) {
            byteSize += this.codeHash.length;
        }
        if (this.args != null) {
            byteSize += this.args.length;
        }
        return Utils.ckbToShannon((long)byteSize);
    }

    public org.nervos.ckb.type.concrete.Script pack() {
        return org.nervos.ckb.type.concrete.Script.builder().setCodeHash(MoleculeConverter.packByte32(this.codeHash)).setArgs(MoleculeConverter.packBytes(this.args)).setHashType(this.hashType.pack()).build();
    }

    public static Script generateSecp256K1Blake160SignhashAllScript(ECKeyPair keyPair) {
        byte[] publicKey = keyPair.getEncodedPublicKey(true);
        return Script.generateSecp256K1Blake160SignhashAllScript(publicKey);
    }

    public static Script generateSecp256K1Blake160SignhashAllScript(byte[] publicKey) {
        byte[] hash = Blake2b.digest((byte[])publicKey);
        hash = Arrays.copyOfRange(hash, 0, 20);
        Script scrip = new Script(SECP256_BLAKE160_SIGNHASH_ALL_CODE_HASH, hash, HashType.TYPE);
        return scrip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script = (Script)o;
        if (!Arrays.equals(this.codeHash, script.codeHash)) {
            return false;
        }
        if (!Arrays.equals(this.args, script.args)) {
            return false;
        }
        return this.hashType == script.hashType;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.codeHash);
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + this.hashType.hashCode();
        return result;
    }

    public static enum HashType {
        DATA(0),
        TYPE(1),
        DATA1(2);

        private byte byteValue;

        private HashType(int byteValue) {
            this.byteValue = (byte)byteValue;
        }

        public byte pack() {
            return this.byteValue;
        }

        public static HashType unpack(byte value) {
            switch (value) {
                case 0: {
                    return DATA;
                }
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return DATA1;
                }
            }
            throw new NullPointerException();
        }
    }
}

