/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign;

import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;

public class ScriptGroup {
    private Script script;
    private ScriptType groupType;
    private List<Integer> inputIndices = new ArrayList<Integer>();
    private List<Integer> outputIndices = new ArrayList<Integer>();

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public ScriptType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(ScriptType groupType) {
        this.groupType = groupType;
    }

    public List<Integer> getInputIndices() {
        return this.inputIndices;
    }

    public void setInputIndices(List<Integer> inputIndices) {
        this.inputIndices = inputIndices;
    }

    public List<Integer> getOutputIndices() {
        return this.outputIndices;
    }

    public void setOutputIndices(List<Integer> outputIndices) {
        this.outputIndices = outputIndices;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Script script;
        private ScriptType groupType;
        private List<Integer> inputIndices = new ArrayList<Integer>();
        private List<Integer> outputIndices = new ArrayList<Integer>();

        private Builder() {
        }

        public static Builder aScriptGroup() {
            return new Builder();
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder setScript(byte[] codeHash, byte[] args, Script.HashType type) {
            Script script = new Script(codeHash, args, type);
            return this.setScript(script);
        }

        public Builder setScript(byte[] codeHash, byte[] args) {
            Script script = new Script(codeHash, args, Script.HashType.TYPE);
            return this.setScript(script);
        }

        public Builder setGroupType(ScriptType groupType) {
            this.groupType = groupType;
            return this;
        }

        public Builder setInputIndices(List<Integer> inputIndices) {
            this.inputIndices = inputIndices;
            return this;
        }

        public Builder addInputIndices(int ... indices) {
            for (int index : indices) {
                this.inputIndices.add(index);
            }
            return this;
        }

        public Builder setOutputIndices(List<Integer> outputIndices) {
            this.outputIndices = outputIndices;
            return this;
        }

        public Builder addOutputIndices(int ... indices) {
            for (int index : indices) {
                this.outputIndices.add(index);
            }
            return this;
        }

        public ScriptGroup build() {
            ScriptGroup scriptGroup = new ScriptGroup();
            scriptGroup.setScript(this.script);
            scriptGroup.setGroupType(this.groupType);
            scriptGroup.setInputIndices(this.inputIndices);
            scriptGroup.setOutputIndices(this.outputIndices);
            return scriptGroup;
        }
    }
}

