/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.signer;

import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.sign.ScriptSigner;
import org.nervos.ckb.sign.signer.Secp256k1Blake160SighashAllSigner;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Transaction;

public class AcpSigner
implements ScriptSigner {
    private Secp256k1Blake160SighashAllSigner secp256K1Blake160SighashAllSigner = Secp256k1Blake160SighashAllSigner.getInstance();
    private static AcpSigner INSTANCE;

    private AcpSigner() {
    }

    public static AcpSigner getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AcpSigner();
        }
        return INSTANCE;
    }

    @Override
    public boolean signTransaction(Transaction transaction, ScriptGroup scriptGroup, Context context) {
        Script script = scriptGroup.getScript();
        ECKeyPair keyPair = context.getKeyPair();
        if (this.isMatched(keyPair, script.args)) {
            return this.secp256K1Blake160SighashAllSigner.signScriptGroup(transaction, scriptGroup, keyPair);
        }
        return false;
    }

    public boolean isMatched(ECKeyPair keyPair, byte[] scriptArgs) {
        return this.secp256K1Blake160SighashAllSigner.isMatched(keyPair, scriptArgs);
    }
}

