/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.type.CellDep;
import org.nervos.ckb.type.CellInput;
import org.nervos.ckb.type.CellOutput;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.RawTransaction;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.MoleculeConverter;

public class Transaction {
    public int version = 0;
    public byte[] hash;
    public List<CellDep> cellDeps = new ArrayList<CellDep>();
    public List<byte[]> headerDeps = new ArrayList<byte[]>();
    public List<CellInput> inputs = new ArrayList<CellInput>();
    public List<CellOutput> outputs = new ArrayList<CellOutput>();
    public List<byte[]> outputsData = new ArrayList<byte[]>();
    public List<byte[]> witnesses = new ArrayList<byte[]>();

    public Transaction() {
    }

    public Transaction(int version, List<CellDep> cellDeps, List<byte[]> headerDeps, List<CellInput> cellInputs, List<CellOutput> cellOutputs, List<byte[]> outputsData, List witnesses) {
        this.version = version;
        this.cellDeps = cellDeps;
        this.headerDeps = headerDeps;
        this.inputs = cellInputs;
        this.outputs = cellOutputs;
        this.outputsData = outputsData;
        this.witnesses = witnesses;
    }

    public byte[] computeHash() {
        Blake2b blake2b = new Blake2b();
        blake2b.update(this.getRawTransaction().pack().toByteArray());
        return blake2b.doFinal();
    }

    public RawTransaction getRawTransaction() {
        RawTransaction rawTransaction = new RawTransaction();
        rawTransaction.version = this.version;
        rawTransaction.cellDeps = this.cellDeps;
        rawTransaction.headerDeps = this.headerDeps;
        rawTransaction.inputs = this.inputs;
        rawTransaction.outputs = this.outputs;
        rawTransaction.outputsData = this.outputsData;
        return rawTransaction;
    }

    public org.nervos.ckb.type.concrete.Transaction pack() {
        return org.nervos.ckb.type.concrete.Transaction.builder().setRaw(this.getRawTransaction().pack()).setWitnesses(MoleculeConverter.packBytesVec(this.witnesses)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public int version = 0;
        public List<CellDep> cellDeps = new ArrayList<CellDep>();
        public List<byte[]> headerDeps = new ArrayList<byte[]>();
        public List<CellInput> inputs = new ArrayList<CellInput>();
        public List<CellOutput> outputs = new ArrayList<CellOutput>();
        public List<byte[]> outputsData = new ArrayList<byte[]>();
        public List witnesses = new ArrayList();

        private Builder() {
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setCellDeps(List<CellDep> cellDeps) {
            this.cellDeps = cellDeps;
            return this;
        }

        public Builder addCellDep(CellDep cellDep) {
            this.cellDeps.add(cellDep);
            return this;
        }

        public Builder addCellDep(byte[] txHash, int index, CellDep.DepType depType) {
            CellDep cellDep = new CellDep();
            cellDep.outPoint = new OutPoint(txHash, index);
            cellDep.depType = depType;
            return this.addCellDep(cellDep);
        }

        public Builder addCellDep(byte[] txHash, int index) {
            return this.addCellDep(txHash, index, CellDep.DepType.DEP_GROUP);
        }

        public Builder setHeaderDeps(List<byte[]> headerDeps) {
            this.headerDeps = headerDeps;
            return this;
        }

        public Builder addHeaderDep(byte[] headerDep) {
            this.headerDeps.add(headerDep);
            return this;
        }

        public Builder setInputs(List<CellInput> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder addInput(CellInput input) {
            this.inputs.add(input);
            return this;
        }

        public Builder addInput(byte[] txHash, int index) {
            return this.addInput(txHash, index, 0L);
        }

        public Builder addInput(byte[] txHash, int index, long since) {
            CellInput input = new CellInput();
            input.previousOutput = new OutPoint(txHash, index);
            input.since = since;
            return this.addInput(input);
        }

        public Builder setOutputs(List<CellOutput> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder addOutput(CellOutput output) {
            this.outputs.add(output);
            return this;
        }

        public Builder addOutput(long capacity, byte[] lockScriptCodeHash, byte[] lockScriptArgs, byte[] typeScriptCodeHash, byte[] typeScriptArgs) {
            Script lockScript = new Script(lockScriptCodeHash, lockScriptArgs, Script.HashType.TYPE);
            Script typeScript = new Script(typeScriptCodeHash, typeScriptArgs, Script.HashType.TYPE);
            CellOutput output = new CellOutput();
            output.capacity = capacity;
            output.lock = lockScript;
            output.type = typeScript;
            return this.addOutput(output);
        }

        public Builder addOutput(long capacity, byte[] lockScriptCodeHash, byte[] lockScriptArgs) {
            Script lockScript = new Script();
            lockScript.args = lockScriptArgs;
            lockScript.codeHash = lockScriptCodeHash;
            lockScript.hashType = Script.HashType.TYPE;
            CellOutput output = new CellOutput();
            output.capacity = capacity;
            output.lock = lockScript;
            output.type = null;
            return this.addOutput(output);
        }

        public Builder setOutputsData(List<byte[]> outputsData) {
            this.outputsData = outputsData;
            return this;
        }

        public Builder addOutputData(byte[] outputData) {
            this.outputsData.add(outputData);
            return this;
        }

        public Builder setWitnesses(List witnesses) {
            this.witnesses = witnesses;
            return this;
        }

        public Builder addWitness(String witness) {
            this.witnesses.add(witness);
            return this;
        }

        public Transaction build() {
            Transaction transaction = new Transaction(this.version, this.cellDeps, this.headerDeps, this.inputs, this.outputs, this.outputsData, this.witnesses);
            return transaction;
        }
    }
}

