/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.math.BigInteger;
import java.util.List;
import org.nervos.ckb.type.CellInput;
import org.nervos.ckb.type.concrete.Byte32;
import org.nervos.ckb.type.concrete.Byte32Vec;
import org.nervos.ckb.type.concrete.Bytes;
import org.nervos.ckb.type.concrete.BytesVec;
import org.nervos.ckb.type.concrete.CellDep;
import org.nervos.ckb.type.concrete.CellDepVec;
import org.nervos.ckb.type.concrete.CellInputVec;
import org.nervos.ckb.type.concrete.CellOutput;
import org.nervos.ckb.type.concrete.CellOutputVec;
import org.nervos.ckb.type.concrete.Uint128;
import org.nervos.ckb.type.concrete.Uint32;
import org.nervos.ckb.type.concrete.Uint64;
import org.nervos.ckb.utils.Numeric;

public class MoleculeConverter {
    public static byte[] toByteArrayLittleEndianUnsigned(BigInteger in, int length) {
        byte[] arr = Numeric.toBytesPadded((BigInteger)in, (int)length);
        byte[] out = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[arr.length - i - 1];
        }
        return out;
    }

    public static Uint32 packUint32(int in) {
        byte[] arr = MoleculeConverter.toByteArrayLittleEndianUnsigned(BigInteger.valueOf(in), Uint32.SIZE);
        return Uint32.builder((byte[])arr).build();
    }

    public static Uint64 packUint64(long in) {
        byte[] arr = MoleculeConverter.toByteArrayLittleEndianUnsigned(BigInteger.valueOf(in), Uint64.SIZE);
        return Uint64.builder((byte[])arr).build();
    }

    public static Uint128 packUint128(BigInteger in) {
        byte[] arr = MoleculeConverter.toByteArrayLittleEndianUnsigned(in, Uint128.SIZE);
        return Uint128.builder((byte[])arr).build();
    }

    public static Byte32 packByte32(byte[] in) {
        return Byte32.builder((byte[])in).build();
    }

    public static Bytes packBytes(byte[] in) {
        if (in == null) {
            return null;
        }
        return Bytes.builder().add(in).build();
    }

    public static BytesVec packBytesVec(List<byte[]> in) {
        Bytes[] arr = new Bytes[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = MoleculeConverter.packBytes(in.get(i));
        }
        return BytesVec.builder().add(arr).build();
    }

    public static Byte32Vec packByte32Vec(List<byte[]> in) {
        Byte32[] arr = new Byte32[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = MoleculeConverter.packByte32(in.get(i));
        }
        return Byte32Vec.builder().add(arr).build();
    }

    public static CellInputVec packCellInputVec(List<CellInput> in) {
        org.nervos.ckb.type.concrete.CellInput[] arr = new org.nervos.ckb.type.concrete.CellInput[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellInputVec.builder().add(arr).build();
    }

    public static CellOutputVec packCellOutputVec(List<org.nervos.ckb.type.CellOutput> in) {
        CellOutput[] arr = new CellOutput[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellOutputVec.builder().add(arr).build();
    }

    public static CellDepVec packCellDepVec(List<org.nervos.ckb.type.CellDep> in) {
        CellDep[] arr = new CellDep[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellDepVec.builder().add(arr).build();
    }
}

