/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class IntegerTypeAdapter
implements JsonSerializer<Integer>,
JsonDeserializer<Integer> {
    public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive("0x" + Integer.toHexString(src));
    }

    public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        String hexValue = json.getAsString().substring(2);
        return Integer.parseUnsignedInt(hexValue, 16);
    }
}

