/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.MoleculeConverter;
import org.nervos.ckb.utils.Utils;

public class CellOutput {
    public long capacity;
    public Script type;
    public Script lock;

    public CellOutput() {
    }

    public CellOutput(long capacity, Script lock) {
        this.capacity = capacity;
        this.lock = lock;
    }

    public CellOutput(long capacity, Script lock, Script type) {
        this.capacity = capacity;
        this.lock = lock;
        this.type = type;
    }

    public long occupiedCapacity(byte[] data) {
        long byteSize = Utils.ckbToShannon((long)8L);
        if (data != null) {
            byteSize += Utils.ckbToShannon((long)data.length);
        }
        if (this.lock != null) {
            byteSize += this.lock.occupiedCapacity();
        }
        if (this.type != null) {
            byteSize += this.type.occupiedCapacity();
        }
        return byteSize;
    }

    public org.nervos.ckb.type.concrete.CellOutput pack() {
        return org.nervos.ckb.type.concrete.CellOutput.builder().setLock(this.lock.pack()).setType(this.type == null ? null : this.type.pack()).setCapacity(MoleculeConverter.packUint64(this.capacity)).build();
    }
}

