/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils.address;

public class AddressFormatException
extends IllegalArgumentException {
    public AddressFormatException() {
    }

    public AddressFormatException(String message) {
        super(message);
    }

    public static class InvalidPrefix
    extends AddressFormatException {
        public InvalidPrefix() {
        }

        public InvalidPrefix(String message) {
            super(message);
        }
    }

    public static class InvalidChecksum
    extends AddressFormatException {
        public InvalidChecksum() {
            super("Checksum does not validate");
        }

        public InvalidChecksum(String message) {
            super(message);
        }
    }

    public static class InvalidDataLength
    extends AddressFormatException {
        public InvalidDataLength() {
        }

        public InvalidDataLength(String message) {
            super(message);
        }
    }

    public static class InvalidCharacter
    extends AddressFormatException {
        public final char character;
        public final int position;

        public InvalidCharacter(char character, int position) {
            super("Invalid character '" + Character.toString(character) + "' at position " + position);
            this.character = character;
            this.position = position;
        }
    }
}

