/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.sign.omnilock.OmnilockArgs;
import org.nervos.ckb.utils.Numeric;

class OmnilockArgsTest {
    OmnilockArgsTest() {
    }

    @Test
    public void testEncode() {
        OmnilockArgs.OmniConfig config = new OmnilockArgs.OmniConfig();
        config.setFlag(15);
        config.setAdminListCellTypeId(Numeric.hexStringToByteArray((String)"0xeb760e1ad345001c6a31ae4ef531c38f94f64f2f6b6ac862a4822248adcb421c"));
        config.setMinimumCKBExponentInAcp(Integer.valueOf(2));
        config.setMinimumSUDTExponentInAcp(Integer.valueOf(1));
        config.setSinceForTimeLock(Long.valueOf(Long.parseUnsignedLong("129d5", 16)));
        config.setTypeScriptHashForSupply(Numeric.hexStringToByteArray((String)"0x1386a372b6b103f1de175dfb16c36f9358385d67239253131100fdd9624d699b"));
        byte[] expected = Numeric.hexStringToByteArray((String)"0feb760e1ad345001c6a31ae4ef531c38f94f64f2f6b6ac862a4822248adcb421c020100000000000129d51386a372b6b103f1de175dfb16c36f9358385d67239253131100fdd9624d699b");
        Assertions.assertArrayEquals((byte[])expected, (byte[])config.encode());
    }

    @Test
    public void testDecode() {
        byte[] bytes = Numeric.hexStringToByteArray((String)"0feb760e1ad345001c6a31ae4ef531c38f94f64f2f6b6ac862a4822248adcb421c020100000000000129d51386a372b6b103f1de175dfb16c36f9358385d67239253131100fdd9624d699b");
        OmnilockArgs.OmniConfig config = OmnilockArgs.OmniConfig.decode((byte[])bytes);
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0xeb760e1ad345001c6a31ae4ef531c38f94f64f2f6b6ac862a4822248adcb421c"), (byte[])config.getAdminListCellTypeId());
        Assertions.assertEquals((int)2, (Integer)config.getMinimumCKBExponentInAcp());
        Assertions.assertEquals((int)1, (Integer)config.getMinimumSUDTExponentInAcp());
        Assertions.assertEquals((long)76245L, (Long)config.getSinceForTimeLock());
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0x1386a372b6b103f1de175dfb16c36f9358385d67239253131100fdd9624d699b"), (byte[])config.getTypeScriptHashForSupply());
    }
}

